h04492
s 00007/00007/00258
d D 1.34 00/08/26 19:52:50 nitehawk 35 34
c convert all logging calls into logmsg
cC
cK24506
e
s 00006/00010/00259
d D 1.33 00/08/22 20:17:49 nitehawk 34 33
c Converting to new logmsg
cC
cHlocalhost.1ststep.net
cK20903
cZ-07:00
e
s 00000/00000/00269
d D 1.32 00/03/07 11:48:11 nitehawk 33 32
c Turn on SCCS flag
cC
cK53951
cX0xa1
e
s 00003/00001/00266
d D 1.31 00/02/29 00:50:38 nitehawk 32 31
c Log nodeid as part of startup process
cC
cK25380
e
s 00001/00001/00266
d D 1.30 00/02/26 23:00:46 nitehawk 31 30
c uplinksendmessage needs messageid parameter
cC
cK20560
e
s 00020/00054/00247
d D 1.29 00/02/15 12:27:14 nitehawk 30 29
c Loop consolidation:  All secondary loops consolidated into
c a single pass.  Main game loop now comprised of two secondary
c loops, one to load sockets into fdsets, another to process input
c post select
cC
cK20436
e
s 00000/00000/00301
d D 1.28 00/02/10 09:22:15 nitehawk 29 28
c Rename: src/hub.c -> src/hub/hub.c
cC
cK30508
cPsrc/hub/hub.c
e
s 00003/00000/00298
d D 1.27 00/02/08 10:41:16 nitehawk 28 27
c Add call to netstartup
cC
cK13891
e
s 00009/00001/00289
d D 1.26 00/02/08 00:51:47 nitehawk 27 26
c Daemon function name setup for split binaries
c Added daemoninitstate to setup state variables according to daemon type
cK10464
e
s 00002/00002/00288
d D 1.25 00/02/05 20:03:48 nitehawk 26 25
c All daemons use the same ticklength and reporting cycle variables
cC
cK63094
e
s 00012/00005/00278
d D 1.24 00/02/05 18:43:06 nitehawk 25 24
c Added loop throttling
cK60978
e
s 00008/00004/00275
d D 1.23 00/02/05 16:05:49 nitehawk 24 23
c filter bad descriptors from processing loop
cC
cK54034
e
s 00028/00012/00251
d D 1.22 00/02/05 13:50:51 nitehawk 23 22
c Uplink messages are now received via input buffers
cK47230
e
s 00037/00028/00226
d D 1.21 00/02/04 20:11:43 nitehawk 22 21
c Added support for live reboots
cC
cK26256
e
s 00001/00003/00253
d D 1.20 00/02/04 10:27:39 nitehawk 21 20
c confcreatelisten expects list pointer instead of descriptor
cC
cK09607
e
s 00001/00001/00255
d D 1.19 00/02/02 17:14:10 nitehawk 20 19
c Hub daemon uses uplinkroutemessage instead of uplinkreceivemessage
cC
cK15134
e
s 00005/00000/00251
d D 1.18 00/02/01 20:55:24 nitehawk 19 18
c Check for interrupted syscall in primary select
cC
cK15314
e
s 00001/00001/00250
d D 1.17 00/02/01 12:25:32 nitehawk 18 17
c Pass message data struct to uplinksendmessage
cC
cK09038
e
s 00024/00002/00227
d D 1.16 00/02/01 11:26:46 nitehawk 17 16
c Added handling for daemon shutdown
cK08578
e
s 00022/00000/00207
d D 1.15 00/02/01 11:22:18 nitehawk 16 15
c Added loop to close sockets marked as STATUS_CLOSE
cK30917
e
s 00003/00003/00204
d D 1.14 00/01/30 13:29:19 nitehawk 15 14
c Updated to use new list data pointer union
cC
cK55928
e
s 00019/00008/00188
d D 1.13 00/01/29 23:47:25 nitehawk 14 13
c Add call to uplinkreceivemessage when an uplink is marked for read
cC
cK58385
e
s 00001/00001/00195
d D 1.12 00/01/23 20:48:12 nitehawk 13 12
c Converting descriptor memory allocation to use new functions
cC
cK26911
e
s 00008/00001/00188
d D 1.11 00/01/20 21:34:33 nitehawk 12 11
c Added call to protocol negotiation
cC
cK29037
e
s 00001/00000/00188
d D 1.10 00/01/13 19:05:20 nitehawk 11 10
c Fix small bug in descriptor tracking
cC
cK09952
e
s 00000/00006/00188
d D 1.9 00/01/13 16:20:18 nitehawk 10 9
c Removed extra call to netstartup - called in daemon.c
cK06768
e
s 00004/00006/00190
d D 1.8 00/01/13 16:14:39 nitehawk 9 8
c Remove need for extra 'masterlisten' pointer
cK15644
e
s 00148/00018/00048
d D 1.7 00/01/12 23:34:37 nitehawk 8 7
c Added more complete descriptor tracking
c Primary hub routing loop in place
c Packet read for uplink connections pending
cC
cK24079
e
s 00002/00002/00064
d D 1.6 00/01/11 12:27:32 nitehawk 7 6
c Converted RCS tags to SCCS tags
cC
cK54827
e
s 00002/00005/00064
d D 1.5 00/01/09 17:59:46 nitehawk 6 5
c Remove pointer assignements for next and prev
cC
cK60974
e
s 00002/00001/00067
d D 1.4 00/01/01 16:56:51 nitehawk 5 4
c Change netlisten call to confcreatelisten -
c Use XML config file to open listen socket
cC
cK08826
e
s 00001/00001/00067
d D 1.3 00/01/01 12:59:02 nitehawk 4 3
c Change calls to uplink and listen to use port and address
cK08499
cZ-08:00
e
s 00004/00042/00064
d D 1.2 99/12/21 00:03:52 nitehawk 3 2
c Pruned out all non-hub daemon code
cC
cK08108
e
s 00106/00000/00000
d D 1.1 99/12/20 22:57:44 nitehawk 2 1
cF1
cK23681
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 99/12/20 22:57:44 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/src/koalamud/src/hub.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK19148
cPsrc/hub.c
cRfd8187fed76588d
cV3
cZ+00:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
D 7
/* $Id: daemon.c,v 1.8 1999/12/08 05:11:22 nitehawk Exp $ */
E 7
I 7
/* %Z% %M% %I% %Z% */
E 7
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

D 7
#define _KOALAMUD_HUB_C "$Id: daemon.c,v 1.8 1999/12/08 05:11:22 nitehawk Exp $"
E 7
I 7
#define _KOALAMUD_HUB_C "%Z% %K% %Z%"
E 7

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "network.h"
#include "log.h"
I 5
#include "conf.h"
I 8
#include "llist.h"
#include "memory.h"
I 12
#include "uplinkprotocol.h"
I 22
#include "reboot.h"
I 23
#include "buffer.h"
E 23
E 22
E 12
E 8
E 5

D 27
koalaerror hubdaemon(void)
E 27
I 27
/* Initialize state variables */
koalaerror daemoninitstate(void)
{
	koptions.daemontype = DAEMON_HUB;
	return KESUCCESS;
};

/* Startup the daemon */
koalaerror rundaemon(void)
E 27
{
I 8
	int selectreturn;
E 8
D 17
	bool running = TRUE;
E 17
D 6
	descriptor masterlisten = {NULL, NULL, 0, 0, {NULL}};
	descriptor uplinkconnection = {NULL, NULL, 0, 0, {NULL}};
E 6
I 6
D 8
	descriptor masterlisten = {0, 0, {NULL}};
	descriptor uplinkconnection = {0, 0, {NULL}};
E 6
	pdescriptor client = NULL;
	char welcome[] = "Welcome to KoalaMud.  This is early development"
		" code.  Please check back later.\n\r";
E 8
I 8
D 9
	pdescriptor masterlisten = NULL;
E 9
	pdescriptor desc = NULL;
	pdescriptor newdesc = NULL;
E 8
	koalaerror acceptreturn;
I 8
	listnodeptr desclist, tmplist;
	fd_set insockets, outsockets, errsockets;
D 34
	char logbuf[MAXLOGLINELEN];
E 34
	int descriptorcount = 0;
	int numuplinks = 0;
	int maxdescriptor = 0;
I 25
	unsigned long loopcount = 0;
	struct timeval waitcycle;
E 25
E 8

I 28
	/* Startup networking */
	netstartup();

E 28
D 10
	if (netstartup() != KESUCCESS)
	{
		logerr("Error starting network, shutting down");
		return KENONETWORK;
	}
D 6

	masterlisten.next = masterlisten.prev = &masterlisten;
	uplinkconnection.next = uplinkconnection.prev = &uplinkconnection;
E 6

E 10
I 8
	desclist = getdescriptorlist();
D 9
	masterlisten = (pdescriptor)malloc(sizeof(descriptor));
	listaddnode(desclist, masterlisten);
E 9
I 9
D 13
	newdesc = (pdescriptor)malloc(sizeof(descriptor));
E 13
I 13
D 21
	newdesc = allocdescriptor();
E 13
	listaddnode(desclist, newdesc);
E 21
E 9

	if (desclist == NULL)
	{
D 35
		logerr("Unable to create descriptor linked list - bail out");
E 35
I 35
		logmsg(LOGCRIT, "Unable to create descriptor linked list - bail out");
E 35
		return KENOMEM;
	}

I 14
D 22
	/* Attempt to create an uplink */
	if (confcreateuplink(desclist) != KESUCCESS)
E 22
I 22
	/* check to see if this was a reboot */
	if (!(kstate.running == DSTATE_REBOOTING &&
				(reloaddescriptors() == KESUCCESS)))
E 22
	{
D 22
		logerr("Error connecting to uplink, use 'link' as an admin to create"
				"an uplink");
	}
E 22
I 22
		/* Attempt to create an uplink */
		if (confcreateuplink(desclist) != KESUCCESS)
		{
D 35
			logerr("Error connecting to uplink, use 'link' as an admin to "
					"create an uplink");
E 35
I 35
			logmsg(LOGWARN, "Error connecting to uplink, use 'link' as an"
					" admin to create an uplink");
E 35
		}
E 22

E 14
E 8
D 3
	/* Create uplink connection if server type is client */
	if (koptions.daemontype == DAEMON_CLIENT)
E 3
I 3
D 22
	/* Start listening for uplink connections */
D 4
	if (netlisten(&masterlisten, koptions.port) < 0)
E 4
I 4
D 5
	if (netlisten(&masterlisten, NULL, koptions.port) < 0)
E 5
I 5
D 8
	if (confcreatelisten(&masterlisten) < 0)
E 8
I 8
D 9
	if (confcreatelisten(masterlisten) < 0)
E 9
I 9
D 21
	if (confcreatelisten(newdesc) < 0)
E 21
I 21
	if (confcreatelisten(desclist) < 0)
E 21
E 9
E 8
E 5
E 4
E 3
	{
D 3
		if (netuplink(&uplinkconnection) < 0)
		{
			logerr("Error starting network interface, shutting down");
			return KENONETWORK;
		}
		masterlisten.next = masterlisten.prev = &masterlisten;
		uplinkconnection.next = uplinkconnection.prev = &masterlisten;
	}

	/* If we are setting up a zone server, we should connect to a hub
	 * server if the uplink is defined, otherwise, start listening on the
	 * uplink port */
	if (koptions.daemontype == DAEMON_ZONE)
	{
		if (koptions.uplinkopts.uplinkopt)
		{
			if (netuplink(&uplinkconnection) < 0)
			{
				logerr("Error starting network interface, shutting down");
				return KENONETWORK;
			}
		}
		else
		{
			if (netlisten(&masterlisten, koptions.port) < 0)
			{
				logerr("Error starting network interface, shutting down");
				return KENONETWORK;
			}
		}
	}
	else
	{
		/* we are starting either a hub server or a client server,
		 * either way, we need a listen socket */
		if (netlisten(&masterlisten, koptions.port) < 0)
		{
			logerr("Error starting network interface, shutting down");
			return KENONETWORK;
		}
E 3
I 3
		logerr("Error starting network interface, shutting down");
		return KENONETWORK;
E 22
I 22
		/* Start listening for uplink connections */
		if (confcreatelisten(desclist) < 0)
		{
D 35
			logerr("Error starting network interface, shutting down");
E 35
I 35
			logmsg(LOGCRIT, "Error starting network interface, shutting down");
E 35
			return KENONETWORK;
		}
E 22
E 3
	}

I 8
D 32
	logmsg("Starting main hub routing loop");
E 32
I 32
D 34
	sprintf(logbuf, "Starting main hub routing loop on node ID: %x",
E 34
I 34
	logmsg(LOGINFO, "Starting main hub routing loop on node ID: %x",
E 34
			kstate.nodeid);
D 34
	logmsg(logbuf);
E 34
E 32
E 8
D 17
	while (running)
E 17
I 17
D 22
	while (kstate.running)
E 22
I 22
	while (kstate.running == DSTATE_RUNNING)
E 22
E 17
	{
D 8
		acceptreturn = netaccept(&masterlisten, &client);
		if (acceptreturn == KENOMEM)
E 8
I 8
		descriptorcount = 0;
		numuplinks = 0;
		maxdescriptor = 0;
		FD_ZERO(&insockets);
		FD_ZERO(&outsockets);
		FD_ZERO(&errsockets);

		for(tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
D 15
			desc = (pdescriptor)tmplist->data;
E 15
I 15
			desc = tmplist->data.desc;
E 15

			// Filter dummy sockets
			if (desc->type == DESCRIPTOR_DUMMY)
			{
				continue;
			}
			
			// Add descriptor to select sets
			if (desc->type != DESCRIPTOR_LISTEN)
			{
				numuplinks++;
				FD_SET(desc->socket, &errsockets);
				FD_SET(desc->socket, &outsockets);
			}
			FD_SET(desc->socket, &insockets);
			descriptorcount++;

			maxdescriptor = (maxdescriptor > desc->socket) ?
				maxdescriptor : desc->socket;
		}

D 25
		snprintf(logbuf, MAXLOGLINELEN,
E 25
I 25
D 26
		if (((loopcount++) % HUBREPORTPERIOD) == 0)
E 26
I 26
		if (((loopcount++) % koptions.reportingperiod) == 0)
E 26
		{
D 34
			snprintf(logbuf, MAXLOGLINELEN,
E 25
				"%d descriptors, %d Listen, %d Uplink, Max FD=%d",
E 34
I 34
			logmsg(LOGINFO, "%d descriptors, %d Listen, %d Uplink, Max FD=%d",
E 34
				descriptorcount, (descriptorcount - numuplinks), (numuplinks),
				maxdescriptor);
D 25
		logdbg(logbuf);
E 25
I 25
D 34
			logmsg(logbuf);
E 34
		}

E 25
		if (numuplinks == 0)
E 8
		{
D 8
			close(masterlisten.socket);
			return KENOMEM;
E 8
I 8
D 34
			logmsg("No Connections, sleeping");
E 34
I 34
			logmsg(LOGINFO, "No Connections, sleeping");
E 34

			if ((selectreturn = select(maxdescriptor + 1, &insockets,
						NULL, NULL, NULL)) < 0)
			{
				if (errno == EINTR)
				{
D 34
					logmsg("Waking up to process signal");
E 34
I 34
					logmsg(LOGINFO, "Waking up to process signal");
E 34
				}
				else
				{
D 35
					logerr("Problems with select - bailing water");
E 35
I 35
					logmsg(LOGERR, "Problems with select - bailing water");
E 35
					continue;
				}
			}
			else
			{
D 34
				logmsg("New uplink in progress - Waking to process");
E 34
I 34
				logmsg(LOGINFO, "New uplink in progress - Waking to process");
E 34
			}
E 8
		}
D 8
		if (acceptreturn == KENOACCEPT)
E 8
I 8

D 25
		// Block progress until there is data on a socket
		// 	Since this is a hub, we don't need to worry about timing :)
E 25
I 25
		// Wait for data on the socket
		waitcycle.tv_sec = 0;
D 26
		waitcycle.tv_usec = MAXHUBTICKLEN;
E 26
I 26
		waitcycle.tv_usec = koptions.ticklen;
E 26
E 25
		if ((selectreturn = select(maxdescriptor + 1, &insockets,
D 25
			NULL, &errsockets, NULL)) < 0)
E 25
I 25
			NULL, &errsockets, &waitcycle)) < 0)
E 25
E 8
		{
I 19
			if (errno == EINTR)
			{
D 34
				logmsg("Waking up to process signal");
E 34
I 34
				logmsg(LOGINFO, "Waking up to process signal");
E 34
				continue;
			}
E 19
D 8
			/* Probaly just no connections waiting
			 * 	shouldn't get this in normal operations */
			logdbg("No connections waiting");
			continue;
E 8
I 8
D 35
			logerr("Main hub routing loop dead - falling out");
E 35
I 35
			logmsg(LOGCRIT, "Main hub routing loop dead - falling out");
E 35
			return KESELECTFAIL;
E 8
		}
I 8
		
I 16
D 30
		/* Close descriptors marked to be closed */
E 30
I 30
		/* Process all data shown by select */
E 30
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			desc = tmplist->data.desc;

D 30
			/* Filter out dummy descriptors */
			if (desc->type == DESCRIPTOR_DUMMY)
E 30
I 30
			/* Filter out invalid descriptors
			 * Since this is a hub daemon, player descriptors are invalids
			 */
			if (desc->type == DESCRIPTOR_DUMMY ||
					desc->type == DESCRIPTOR_NULL ||
					desc->type == DESCRIPTOR_PLAYER)
E 30
			{
				continue;
			}

D 30
			/* Is this descriptor marked for closure */
			if (desc->status == STATUS_CLOSE)
E 30
I 30
			/* Close descriptors marked to be closed */
			if (desc->status == STATUS_CLOSE ||
					FD_ISSET(desc->socket, &errsockets))
E 30
			{
				tmplist = listprevnode(tmplist);
				listremovenode(desclist, desc);
				FD_CLR(desc->socket, &insockets);
				FD_CLR(desc->socket, &outsockets);
				netclose(desc);
			}
D 30
		}

E 16
		/* Close Sockets in error set */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
D 15
			desc = (pdescriptor)tmplist->data;
E 15
I 15
			desc = tmplist->data.desc;
E 15
E 8

D 8
		netwrite(client, COPYRIGHTSTR, strlen(COPYRIGHTSTR));
		netwrite(client, welcome, strlen(welcome));
E 8
I 8
			/* Filter out dummy descriptors */
			if (desc->type == DESCRIPTOR_DUMMY)
			{
				continue;
			}
E 30
			
D 30
			/* If this descriptor has an error on it: */
			if (FD_ISSET(desc->socket, &errsockets))
			{
				FD_CLR(desc->socket, &insockets);
				FD_CLR(desc->socket, &outsockets);
I 11
				tmplist = listprevnode(tmplist);
E 11
				listremovenode(desclist, desc);
				netclose(desc);
			}
		}

		/* Handle new connections and route inbound data around the network */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
D 15
			desc = (pdescriptor)tmplist->data;
E 15
I 15
			desc = tmplist->data.desc;
E 15

			/* Filter out dummy descriptors */
			if (desc->type == DESCRIPTOR_DUMMY)
			{
				continue;
			}

			/* Is there data on the socket */
E 30
I 30
			/* Receive data from network */
E 30
			if (FD_ISSET(desc->socket, &insockets))
			{
				/* Are we a listener? */
				if (desc->type == DESCRIPTOR_LISTEN)
				{
D 9
					acceptreturn = netaccept(masterlisten, &newdesc);
E 9
I 9
					acceptreturn = netaccept(desc, &newdesc);
E 9
					if (acceptreturn == KENOMEM)
					{
D 9
						close(masterlisten->socket);
E 9
						return KENOMEM;
					}
					if (acceptreturn == KENOACCEPT)
					{
						/* Probaly just no connections waiting
						 * 	shouldn't get this in normal operations */
D 35
						logdbg("No connections waiting");
E 35
I 35
						logmsg(LOGWARN, "No connections waiting");
E 35
						continue;
					}
					netwrite(newdesc, magic.daemonmagic,
							strlen(magic.daemonmagic));
					listaddnode(desclist, newdesc);
D 30
				}
E 30
I 30
				}  // Accept new connection
E 30
I 14
D 23
				/* Read data and route it to appropriate server */
				else if (desc->type == DESCRIPTOR_UNKNOWN &&
							desc->status < STATUS_NOMINAL)
				{
					/* This is an uplink, but we don't know what type yet
					 * - Handle protocol negotiation */
					uplinknegotiatestage(desc);
				}
				/* Otherwise we must be handling an uplink message */
E 23
E 14
				else
				{
D 14
					/* Read data and route it to appropriate server */
I 12
					if (desc->type == DESCRIPTOR_UNKNOWN &&
							desc->status < STATUS_NOMINAL)
					{
						/* This is an uplink, but we don't know what type yet
						 * - Handle protocol negotiation */
						uplinknegotiatestage(desc);
					}
E 14
I 14
D 23
					/* For now don't do any routing of incomming message
					 * packets, just handle them like they are ours */
D 20
					uplinkreceivemessage(desc);
E 20
I 20
					uplinkroutemessage(desc);
E 23
I 23
					/* normal uplinks read into the buffer */
					buffer_receive(desc);
E 23
E 20
E 14
E 12
				}
I 23
D 30
			}
		}

		/* Loop through descriptors and parse input */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			desc = tmplist->data.desc;
E 30
I 30
			}  // Receive data
E 30

I 24
D 30
			/* Filter non-uplink descriptors */
			if (desc->type == DESCRIPTOR_DUMMY || desc->type == DESCRIPTOR_NULL
					|| desc->type == DESCRIPTOR_LISTEN ||
					desc->type == DESCRIPTOR_PLAYER)
E 30
I 30
			/* This is as far as listen sockets need to go */
			if (desc->type == DESCRIPTOR_LISTEN)
			{
E 30
				continue;
I 30
			}
E 30

I 30
			/* Parse pending data */
E 30
E 24
			if (desc->type == DESCRIPTOR_UNKNOWN &&
						desc->status < STATUS_NOMINAL)
			{
				/* This is an uplink, but we don't know what type yet
				 * - Handle protocol negotiation
				 */
				uplinknegotiatestage(desc);
			}
			/* We can't uplink to a client server */
D 24
			else if (desc->type >= DESCRIPTOR_HUBSRV &&
					desc->type <= DESCRIPTOR_ZONESRV &&
					desc->status == STATUS_NOMINAL)
E 24
I 24
			else
E 24
			{
				/* If we have input on an uplink, pass it off to
				 * uplinkreceivemessage
				 */
D 24
				uplinkreceivemessage(desc);
E 24
I 24
				uplinkroutemessage(desc);
E 24
E 23
			}
I 17
D 30
		}
	}
E 30
I 30
		}  // Select processor loop
	} // Main daemon loop
E 30

D 22
	/* If we get here, we were told to shutdown the system, scan through the
	 * descriptor list and send a disconnect message to all uplinks */
	for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
E 22
I 22
	if (kstate.running == DSTATE_SHUTDOWN)
E 22
	{
D 22
		message_data msgdata;
		msgdata.data = NULL;

		desc = tmplist->data.desc;
		
		switch (desc->type)
E 22
I 22
		/* If we get here, we were told to shutdown the system, scan through the
		 * descriptor list and send a disconnect message to all uplinks */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
E 22
		{
D 22
			case DESCRIPTOR_HUBSRV:
			case DESCRIPTOR_CLIENTSRV:
			case DESCRIPTOR_ZONESRV:
				/* Its an uplink - send a disconnect message */
D 18
				uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, NULL);
E 18
I 18
				uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata);
E 18
				break;
E 22
I 22
			message_data msgdata;
			msgdata.data = NULL;
E 22

D 22
			default:
				continue;
E 22
I 22
			desc = tmplist->data.desc;
			
			switch (desc->type)
			{
				case DESCRIPTOR_HUBSRV:
				case DESCRIPTOR_CLIENTSRV:
				case DESCRIPTOR_ZONESRV:
					/* Its an uplink - send a disconnect message */
D 31
					uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata);
E 31
I 31
					uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata, 0);
E 31
					break;

				default:
					continue;
			}
E 22
E 17
		}
E 8
D 12

E 12
D 8
		netclose(client);
E 8
	}
	
	return KESUCCESS;
}
E 2
I 1
E 1
