/* @(#) parser.c 1.9 @(#) */
/***************************************************************\
*	Copyright (c) 1999-00 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: PARSER
*
*	Command parsers
\***************************************************************/

#define _KOALAMUD_PARSER_C "@(#) nitehawk@winghove.1ststep.net|lib/koala/parser.c|20001105050815|50671 @(#)"

#include "autoconf.h"

#include "version.h"
#include "log.h"
#include "koalatypes.h"
#include "buffer.h"
#include "memory.h"
#include "kparser.h"

/* commandparser - parse an incoming command into arguments and call
 * handler */
koalaerror commandparser(pdescriptor desc)
{
	char *wordbuf = NULL;
	char *wordcur = NULL;
	int wordlen = WORDLENSTEP;
	koalaerror kerr;
	pcommandentry cmd;
	argument *arglist = NULL;

	/* verify that the client has a line of input */
	if (!buffer_isalinein(desc))
	{
		return KESUCCESS;
	}

	/* Allocate memory to read a word from the buffer */
	wordbuf = kmalloc(sizeof(char) * WORDLENSTEP, ALLOC_TEMP);
	if (wordbuf == NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for word buffer");
		return KENOMEM;
	}
	wordcur = wordbuf;

	/* Get a word from the buffer */
	while ((kerr = buffer_readword(desc, wordcur, WORDLENSTEP)) == KENOMEM)
	{
		wordcur = krealloc(wordbuf, wordlen + WORDLENSTEP, ALLOC_TEMP);
		if (wordcur == NULL)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for word buffer");
			return KENOMEM;
		}
		wordbuf = wordcur;
		wordcur = wordbuf + wordlen - 1;
		wordlen += WORDLENSTEP;
	}
	if (kerr == KENOTENOUGH)
	{
		/* There wasn't any data buffered.  Return success, even though we
		 * didn't do anything */
		kmfree(wordbuf, ALLOC_TEMP);
		return KESUCCESS;
	}

	/* At this point, we have a full word read in from the buffer - Pass it
	 * though the search algorithm for a match */
	if ((cmd = clsearch(wordbuf, desc->data.character->abbreviate)) == NULL)
	{
		/* No match was found */
		buffer_queue(desc, UNKNOWNCOMMANDRESPONSE,
				strlen(UNKNOWNCOMMANDRESPONSE));
		buffer_flushline(desc);
		/* Free memory used by word buffer */
		kmfree(wordbuf, ALLOC_TEMP);

		return KESUCCESS;
	}

	/* Need to parse remainder of input line into requested arguments */

	/* Call out to command handler */
	cmd->handler(desc, &arglist);

	/* Free memory used by word buffer */
	kmfree(wordbuf, ALLOC_TEMP);
	
	return KESUCCESS;
}

/* clsearch - Preform a linear search on the command table
 *   This function will do abbreviation matching if requested */
/* Returns a pointer to the command entry or null if it is not found */
/* Note, this is simply a wrapper around clsearchnorm and clsearchabbrev */
pcommandentry clsearch(char *word, bool matchabbrev)
{
	/* Time Saver - If no commands are currently loaded, short cycle and
	 * return NULL
	 */
	if (ctablehead == NULL)
		return NULL;

	/* There are two search sets here.
	 *   1) Search for exact match.
	 *   2) Search for first part match of a command */
	if (matchabbrev)
	{

	}
	else
	{
		return clsearchnorm(word);
	}

	return NULL;
}
/* clsearchnorm - Preform a linear search on the command table
 *   This function will do abbreviation matching if requested */
/* Returns a pointer to the command entry or null if it is not found */
pcommandentry clsearchnorm(char *word)
{
	pcommandentry cur = ctablehead;
	int cmpres;

	/* Verify the command table exists */
	if (ctablehead == NULL)
		return NULL;

	/* initially, we just search the entire loop.  At some point, this
	 * should be optimized to include starting characters so we only
	 * search starting at the first command alphabetically (maintain
	 * an ordered list), and break out when the strcmp returns > 0
	 */

	/* We are searching for an exact match.  Fall out as soon as the compare
	 * returns > 0
	 */
	while (cur && (cmpres = strncasecmp(cur->command, word,
					strlen(cur->command))) < 0)
	{
		cur = cur->next;
	}

	if (cmpres == 0)
		return cur;

	return NULL;
}
