h41224
s 00004/00002/00204
d D 1.12 00/11/04 18:51:42 nitehawk 13 12
c Save abbreviate flag through reboot.
cC
cHwinghove.1ststep.net
cK33826
cZ-08:00
e
s 00003/00002/00203
d D 1.11 00/08/26 19:52:48 nitehawk 12 11
c convert all logging calls into logmsg
cC
cHlocalhost.1ststep.net
cK26525
cZ-07:00
e
s 00001/00001/00204
d D 1.10 00/03/11 00:45:51 nitehawk 11 10
c Fix typo in reboot recovery message
cC
cHparanor.1ststep.net
cK25199
cZ+00:00
e
s 00000/00000/00205
d D 1.9 00/03/07 11:48:12 nitehawk 10 9
c Turn on SCCS flag
cC
cK46208
cX0xa1
e
s 00010/00005/00195
d D 1.8 00/02/24 19:11:46 nitehawk 9 8
c Convert memory calls to use wrapper functions
cC
cK25083
e
s 00000/00000/00200
d D 1.7 00/02/12 10:04:37 nitehawk 8 7
c Rename: lib/reboot.c -> lib/koala/reboot.c
cC
cK51273
cPlib/koala/reboot.c
e
s 00000/00000/00200
d D 1.6 00/02/07 23:56:29 nitehawk 7 6
c Rename: src/reboot.c -> lib/reboot.c
cC
cK12930
cPlib/reboot.c
e
s 00003/00000/00197
d D 1.5 00/02/05 18:59:40 nitehawk 6 5
c Initialize message id while reading desriptors from file
cC
cK17851
e
s 00011/00003/00186
d D 1.4 00/02/05 14:36:09 nitehawk 5 4
c Append PID to reboot state file name
cC
cK06372
e
s 00009/00001/00180
d D 1.3 00/02/04 20:19:25 nitehawk 4 3
c small bug fixes
cC
cK56891
e
s 00072/00002/00109
d D 1.2 00/02/04 16:55:45 nitehawk 3 2
c Reload function complete
cK40066
e
s 00111/00000/00000
d D 1.1 00/02/04 14:14:08 nitehawk 2 1
cF1
cK06859
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/02/04 14:14:08 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/src/reboot.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK36937
cPsrc/reboot.c
cR5cef6a79d9c8198e
cV3
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: REBOOT
*
*	This module implements live reboots
\***************************************************************/

#define _KOALAMUD_DAEMON_C "%Z% %K% %Z%"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "uplinkprotocol.h"
#include "reboot.h"
#include "llist.h"
#include "memory.h"
#include "network.h"

/* FIXME:  We need checking for null pointers during all allocations */

/* Write the current state to a file in prep for a live reboot */
koalaerror prepforreboot(void)
{
	listnodeptr desclist;
	pdescriptor desc;
	FILE *statefile;
D 4
	char rebootmsg[] = "Koala rebooting - one moment please";
E 4
I 4
	char rebootmsg[] = "Koala rebooting - one moment please\r\n";
I 5
	char filename[128];
	
	/* build filename */
	snprintf(filename, 128, "%s.%d", REBOOTSTATEFILE, getpid());
E 5
E 4

	/* open state file */
D 5
	if ((statefile = fopen(REBOOTSTATEFILE, "w")) == NULL)
E 5
I 5
	if ((statefile = fopen(filename, "w")) == NULL)
E 5
	{
D 12
		logerr("Unable to open state file for reboot");
E 12
I 12
		logmsg(LOGCRIT, "Unable to open state file for reboot");
E 12

	}

	/* Store state for all sockets */
	desclist = getdescriptorlist();
	for(;desclist; desclist = listnextnode(desclist))
	{
		/* Get a pointer to the descriptor */
		desc = desclist->data.desc;

		/* Filter Dummy and Null sockets */
		if (desc->type == DESCRIPTOR_NULL || desc->type == DESCRIPTOR_DUMMY)
		{
			continue;
		}

		// turn close-on-exec off
		fcntl(desc->socket, F_SETFD, 0);

		/* Print the first line of descriptor info */
		fprintf(statefile, "%d %d %d %d\n",
				desc->socket, desc->type, desc->status, desc->nodeid);
		switch(desc->type)
		{
			case DESCRIPTOR_PLAYER:
				/* Save name and state */
D 13
				fprintf(statefile, "%d %d %s\n",
E 13
I 13
				fprintf(statefile, "%d %d %d %s\n",
						desc->data.character->abbreviate,
E 13
						desc->data.character->state,
						strlen(desc->data.character->name),
						desc->data.character->name);
				netwrite(desc, rebootmsg, strlen(rebootmsg));
				break;

			case DESCRIPTOR_UNKNOWN:	// no extra data
			case DESCRIPTOR_LISTEN:		// no extra data
			case DESCRIPTOR_HUBSRV:		// no extra data
			case DESCRIPTOR_ZONESRV:	// no extra data
			case DESCRIPTOR_CLIENTSRV:	// no extra data
			default:
				break;
		}
	}

	/* close state file */
	fclose(statefile);

	/* Successfully prepped for reboot */
	return KESUCCESS;
}

/* Save socket state and reboot daemon */
koalaerror rebootdaemon(void)
{
	koalaerror kerr;

	kerr = prepforreboot();
D 3
	return KESUCCESS;
E 3
I 3
	return kerr;
E 3
}

/* Rebuild descriptor list from state file */
koalaerror reloaddescriptors(void)
{
	pdescriptor desc;
	listnodeptr desclist;
	char linebuffer[1024];
I 3
	FILE *statefile;
	int namelen;
	char backmsg[] = "Finished rebooting - Koala back.\r\n"
D 11
		"Type version to see new version informaion\r\n";
E 11
I 11
		"Type version to see new version information\r\n";
E 11
I 5
	char filename[128];
	
	/* build filename */
	snprintf(filename, 128, "%s.%d", REBOOTSTATEFILE, getpid());
E 5
E 3

	/* Attempt to open state file */
I 3
D 5
	if ((statefile = fopen(REBOOTSTATEFILE, "r")) == NULL)
E 5
I 5
	if ((statefile = fopen(filename, "r")) == NULL)
E 5
	{
I 4
		/* Set the state to running */
		kstate.running = DSTATE_RUNNING;
E 4
D 12
		logerr("Unable to open reboot state file, continuing standard bootup");
E 12
I 12
		logmsg(LOGCRIT, "Unable to open reboot state file,"
				" continuing standard bootup");
E 12
		return KEFOPEN;
	}

E 3
	/* get the descriptor list */
	desclist = getdescriptorlist();

I 3
	/* Loop through each line of the state file */
	while(fgets(linebuffer, 1024, statefile))
	{
		/* Allocate memory for the descriptor */
		desc = allocdescriptor();
		
		/* parse out string into descriptor variables */
		sscanf(linebuffer, "%d %d %d %d\n",
				&(desc->socket), (int *)&(desc->type), (int *)&(desc->status),
				(int *)&(desc->nodeid));
		switch(desc->type)
		{
			case DESCRIPTOR_PLAYER:
				/* Allocate memory for player information */
D 9
				desc->data.character = malloc(sizeof(character));
E 9
I 9
				desc->data.character = kmalloc(sizeof(character),
						ALLOC_DESCRIPTOR);
E 9

				/* Save name and state */
D 13
				fscanf(statefile, "%d %d ",
E 13
I 13
				fscanf(statefile, "%d %d %d ",
						(int *)&(desc->data.character->abbreviate),
E 13
						(int *)&(desc->data.character->state),
						&namelen);
				fgets(linebuffer, 1024, statefile);

				/* Alocate memory for name string */
D 9
				desc->data.character->name = malloc(namelen+2);
E 9
I 9
				desc->data.character->name = kmalloc(namelen+2,
						ALLOC_DESCRIPTOR);
E 9
				bzero(desc->data.character->name, namelen+2);
				strncpy(desc->data.character->name, linebuffer, namelen);

				/* Write a message saying the server is back */
				netwrite(desc, backmsg, strlen(backmsg));
				break;

			case DESCRIPTOR_HUBSRV:		// no extra data
				/* Allocate memory for player information */
D 9
				desc->data.hubsrv = malloc(sizeof(hubsrvdata));
E 9
I 9
				desc->data.hubsrv = kmalloc(sizeof(hubsrvdata),
						ALLOC_DESCRIPTOR);
E 9
I 6
				desc->data.hubsrv->curmsg.messageid = 0;
E 6
				break;

			case DESCRIPTOR_ZONESRV:	// no extra data
				/* Allocate memory for player information */
D 9
				desc->data.zonesrv = malloc(sizeof(zonesrvdata));
E 9
I 9
				desc->data.zonesrv = kmalloc(sizeof(zonesrvdata),
						ALLOC_DESCRIPTOR);
E 9
I 6
				desc->data.zonesrv->curmsg.messageid = 0;
E 6
				break;
				
			case DESCRIPTOR_CLIENTSRV:	// no extra data
				/* Allocate memory for clientsrv information */
D 9
				desc->data.clientsrv= malloc(sizeof(clientsrvdata));
E 9
I 9
				desc->data.clientsrv = kmalloc(sizeof(clientsrvdata),
						ALLOC_DESCRIPTOR);
E 9
I 6
				desc->data.clientsrv->curmsg.messageid = 0;
E 6
				break;

			case DESCRIPTOR_UNKNOWN:	// no extra data
			case DESCRIPTOR_LISTEN:		// no extra data
			default:
				break;
		}

		/* Make sockets close again */
		fcntl(desc->socket, F_SETFD, 1);
I 4
		
		/* Add descriptor to linked list */
		listaddnode(desclist, desc);
E 4
	}

	/* Close and delete state file */
	fclose(statefile);
D 5
	unlink(REBOOTSTATEFILE);
E 5
I 5
	unlink(filename);
E 5
I 4

	/* Set the state to running */
	kstate.running = DSTATE_RUNNING;
E 4

	/* We successfully loaded all the descriptors */
E 3
	return KESUCCESS;
}
D 3

E 3
E 2
I 1
E 1
