h11259
s 00000/00000/00504
d D 1.11 00/03/07 11:48:03 nitehawk 12 11
c Turn on SCCS flag
cC
cK11687
cX0xa1
e
s 00000/00000/00504
d D 1.10 00/03/06 22:42:20 nitehawk 11 10
c Delete: lib/vm/fs.c
cK25314
cPBitKeeper/deleted/.del-fs.c
e
s 00000/00000/00504
d D 1.9 00/03/06 18:41:46 nitehawk 10 9
c Rename: lib/db/fs.c -> lib/vm/fs.c
cK36395
cPlib/vm/fs.c
e
s 00003/00000/00501
d D 1.8 00/02/20 21:46:19 nitehawk 9 8
c Log a message when creating a new root filesystem
cC
cK15584
e
s 00001/00001/00500
d D 1.7 00/02/19 17:54:56 nitehawk 8 7
c Move lib specific include files
cK09673
e
s 00001/00001/00500
d D 1.6 00/02/18 21:38:33 nitehawk 7 6
c Leaf directories with no subdirectories only have two links
cK09315
e
s 00186/00007/00315
d D 1.5 00/02/18 11:43:21 nitehawk 6 5
c Finished up dbinitdb.
cC
cK09316
e
s 00057/00004/00265
d D 1.4 00/02/17 22:23:43 nitehawk 5 4
c Finish up allocateblock
c Finish up creation of root directory.
cC
cK12276
e
s 00033/00014/00236
d D 1.3 00/02/17 18:43:28 nitehawk 4 3
c Convert to using block aligned mapping wrappers
cC
cK24315
e
s 00161/00040/00089
d D 1.2 00/02/17 00:15:24 nitehawk 3 2
c Most of dbnewfs complete.  ToDo: Finish putting together root dirent
c zeroblock added to clean up new blocks for data.  This also resizes
c the database as needed.
cC
cK10701
e
s 00129/00000/00000
d D 1.1 00/02/16 20:18:19 nitehawk 2 1
cF1
cK61730
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/02/16 20:18:19 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/lib/db/fs.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK09456
cPlib/db/fs.c
cR44aa7dc196ffc392
cV2
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

#define _KOALAMUD_FS_C "%Z% %K% %Z%"

#include "autoconf.h"
#include <sys/stat.h>
#include <sys/mman.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"
D 3
#include "dnode.h"
#include "fs.h"
E 3
I 3
D 8
#include "dbinternal.h"
E 8
I 8
#include "lib/dbinternal.h"
E 8
I 4
#include "db.h"
E 4
E 3

/* See database.format for the specification detailing the workings of the
 * database
 */

/* dbnewfs
 * 	Create a new database file and populate basic structures.
 */
koalaerror dbnewfs(char *dbpath)
{
	int dbfd = -1;	// File handle to the database
	void *baseaddr = NULL;
	void *blkaddr = NULL;
	superblock *sb = NULL;
D 3
	char blockzero[BLOCKSIZE] = { '\0' };
E 3
	struct timeval tod;
	int blocknum = 0;
	int blockdnode = 0;
	int dnodenum = 0;
	dnode *dn = NULL;
I 3
	kdbfs_blockid_t	blockid;
	u_int8_t *byte;
E 3

	/* First we'll try to open the file for writing.  This will also have the
	 * effect of truncating the file to 0 bytes
	 */
D 3
	if ((dbfd = open(dbpath, O_RDWR | O_CREAT | O_TRUNC)) == -1)
E 3
I 3
	if ((dbfd = open(dbpath, O_RDWR | O_CREAT | O_TRUNC, 0660)) == -1)
E 3
	{
		logerr("Unable to open database file");
		return KEFOPEN;
	}

D 3
	/* Size the file appropriately by writing zeros */
	write(dbfd, blockzero, BLOCKSIZE);
E 3
I 3
	/* Zero out block 0 */
	zeroblock(dbfd, 0);
E 3

	/* Now we try mapping the database file into memory */
D 4
	baseaddr = mmap(NULL, sizeof(superblock), PROT_READ | PROT_WRITE, 
			MAP_SHARED, dbfd, 0);
	if (baseaddr == NULL)
E 4
I 4
	if ((baseaddr = mmapblockaligned(dbfd, 0, 1)) == NULL)
E 4
	{
		close(dbfd);
		logerr("Unable to map new database file");
		return KENOMEM;
	}

D 3
	/* We now have the new database file mapped in with enough space for block
	 * 0 and the first superblock */
	sb = (superblock *)baseaddr;

	sb->fs_size = 1;
	sb->fs_sbsize = 1;

	sb->fs_clean = FS_CLEAN;

	/* Setup dnode table location and reserve */
	sb->fs_dbno = 1; // SB0's dnode table starts at block 1 (offset 512)
	sb->fs_dtsize = FS_DNODEBLOCKS;

	/* Find position for block bitmap */
	sb->fs_btno = sb->fs_dbno + sb->fs_dtsize;
	sb->fs_btsize = FS_BITMAPBLOCKS;

	/* Number of free blocks and dnodes */
	sb->fs_dfree = FS_DNODESBASE;
	sb->fs_bfree = FS_BLOCKSBASE - FS_DNODEBLOCKS - FS_BITMAPBLOCKS - 1;

	/* get the time of day */
	gettimeofday(&tod, NULL);
	sb->fs_ctime = tod.tv_sec;
	sb->fs_ctimesec = tod.tv_usec;
	sb->fs_ltime = tod.tv_sec;
	sb->fs_ltimesec = tod.tv_usec;
E 3
I 3
	/* fill in the superblock */
	{
		/* We now have the new database file mapped in with enough space for
		 * block 0 and the first superblock */
		sb = (superblock *)baseaddr;

		sb->fs_clean = FS_CLEAN;

		/* Database FS size */
		sb->fs_dsize = FS_DNODESBASE;
		sb->fs_sbdsize = FS_DNODESBASE;
		sb->fs_size = FS_BLOCKSBASE;
		sb->fs_sbsize = FS_BLOCKSBASE;

		/* Find position for block bitmap */
		sb->fs_btno = 1;
		sb->fs_btsize = FS_BITMAPBLOCKS;

		/* Setup dnode table location and reserve */
		sb->fs_dbno = sb->fs_btno + FS_BITMAPBLOCKS; 
		sb->fs_dtsize = sb->fs_sbdsize / FS_DNODESPERBLOCK;

		/* Number of free blocks and dnodes */
		sb->fs_dfree = FS_DNODESBASE;
		sb->fs_bfree = sb->fs_size - sb->fs_dtsize - sb->fs_btsize - 1;

		/* Location of first free objects */
		sb->fs_ffdnode = DNODE_ROOTOWN + 1;
		sb->fs_ffblock = sb->fs_dtsize + sb->fs_btsize + 1;

		/* get the time of day */
		gettimeofday(&tod, NULL);
		sb->fs_ctime = tod.tv_sec;
		sb->fs_ctimesec = tod.tv_usec;
		sb->fs_ltime = tod.tv_sec;
		sb->fs_ltimesec = tod.tv_usec;

		/* Set the last mount to 'unmounted' so that we know this is a new
		 * database
		 */
		strcpy(sb->fs_lastmnt, "unmounted");
	}
E 3

D 3
	/* Set the last mount to 'unmounted' so that we know this is a new
	 * database
	 */
	strcpy(sb->fs_lastmnt, "unmounted");
E 3
I 3
	/* Create block bitmap */
	{
		/* First write out enough blocks for the map */
		for (blocknum = sb->fs_btno; blocknum < sb->fs_btno + sb->fs_btsize;
				blocknum++)
		{
			zeroblock(dbfd, blocknum);
		}

		/* Map the entire bitmap */
D 4
		blkaddr = mmap(NULL, BLOCKSIZE * sb->fs_btsize, PROT_READ | PROT_WRITE, 
				MAP_SHARED, dbfd, sb->fs_btno * BLOCKSIZE);
E 4
I 4
		if ((blkaddr = mmapblockaligned(dbfd, sb->fs_btno,
						sb->fs_btsize)) == NULL)
		{
			closemapfile(dbfd);
			logerr("Unable to map new blocks");
			return KENOMEM;
		}
E 4

		/* Now we just need to turn on the bits for all the blocks used by the
		 * dnode table, super block, and block bitmap */
		for (blockid = 0; blockid < (1 + sb->fs_btsize + sb->fs_dtsize);
				blockid++)
		{
			/* This is kindof a tricky way to turn on the bit representing the
			 * block without touching anything around it.  Read carefully */
			byte = blkaddr + (blockid/8);
			*byte |= ((u_int8_t)0x80>> (blockid%8));
		}

		/* We're done building the block bitmap, unmap the block(s) now */
D 4
		munmap(blkaddr, BLOCKSIZE * sb->fs_btsize);
E 4
I 4
		mapfree(blkaddr);
E 4
	}
E 3

	/* Build the dnode table */
	for (blocknum = sb->fs_dbno; blocknum < (sb->fs_dbno + sb->fs_dtsize);
			blocknum++)
	{
D 3
		/* Write a new block to the dbfile */
		write(dbfd, blockzero, BLOCKSIZE);
E 3
I 3
		/* Zero the block out for the current portion of the inode table */
		zeroblock(dbfd, blocknum);

E 3
		/* Map the block into memory */
D 4
		blkaddr = mmap(NULL, BLOCKSIZE, PROT_READ | PROT_WRITE, 
D 3
			MAP_SHARED, dbfd, blocknum * BLOCKSIZE + 1);
E 3
I 3
			MAP_SHARED, dbfd, blocknum * BLOCKSIZE);
E 4
I 4
		if ((blkaddr = mmapblockaligned(dbfd, blocknum,
						1)) == NULL)
		{
			closemapfile(dbfd);
			logerr("Unable to map new blocks");
			return KENOMEM;
		}
E 4
E 3

		for (blockdnode = 0; blockdnode < FS_DNODESPERBLOCK; blockdnode++)
		{
			/* Point to the dnode */
			dn = blkaddr + (blockdnode * sizeof(dnode));

			/* Fill in dnode attributes */ 
			dn->d_num = dnodenum;
			dn->d_nodetype = DNTYPE_FREE;

			dnodenum++;
		}

		/* Unmap the block */
D 4
		munmap(blkaddr, BLOCKSIZE);
E 4
I 4
		mapfree(blkaddr);
E 4
	}
I 3

	/* Create root directory entry - Dnode 0 */
	{
I 5
		void *fblockaddr;
		kdb_dirent *dir;

E 5
		/* Map to the dnode table */
D 4
		blkaddr = mmap(NULL, BLOCKSIZE * sb->fs_dtsize, PROT_READ | PROT_WRITE, 
				MAP_SHARED, dbfd, sb->fs_dbno * BLOCKSIZE);
E 4
I 4
		if ((blkaddr = mmapblockaligned(dbfd, sb->fs_dbno,
						sb->fs_dtsize)) == NULL)
		{
			closemapfile(dbfd);
			logerr("Unable to map new blocks");
			return KENOMEM;
		}
E 4
D 6
		dn = blkaddr;
E 6
I 6
		/* Point to the root dnode */
		dn = blkaddr + DNODE_ROOT * sizeof(dnode);
E 6
		dn->d_nodetype = DNTYPE_DIRECTORY;
D 6
		dn->d_links = 1;
E 6
I 6
		dn->d_links = 2;
		dn->d_size = 512;
		dn->d_blocks = 1;
E 6

I 5
		/* Set owners */
		dn->d_uid = DNODE_ROOTOWN;
		dn->d_gid = DNODE_ROOTOWN;

E 5
		/* Allocate blocks for root directory */
I 5
		dn->d_db[0] = allocateblock(dbfd, sb);
E 5

		/* Timestamp root node */
		gettimeofday(&tod, NULL);
		dn->d_ctime = dn->d_atime = dn->d_mtime = tod.tv_sec;
		dn->d_ctimesec = dn->d_atimesec = dn->d_mtimesec = tod.tv_usec;

I 5
		/* Map to the file block */
		fblockaddr = mmapblockaligned(dbfd, dn->d_db[0], 1);

		/* Now we need to write out the base directory structure */
		dir = fblockaddr;
		dir->d_dnode = DNODE_ROOT;
D 6
		dir->d_namelen = 1;
E 6
I 6
		dir->d_type = DE_DIR;
E 6
		strcpy(dir->d_name, ".");
I 6
		dir->d_namelen = strlen(dir->d_name);
E 6
		dir->d_reclen = sizeof(dir->d_dnode) + sizeof(dir->d_reclen) + 1 +
				sizeof(dir->d_namelen) + dir->d_namelen + sizeof(dir->d_type);

D 6
		dir = fblockaddr + dir->d_reclen + 1;
E 6
I 6
		dir = (void*)dir + dir->d_reclen + 1;
E 6
		dir->d_dnode = DNODE_ROOT;
D 6
		dir->d_namelen = 2;
E 6
I 6
		dir->d_type = DE_DIR;
E 6
		strcpy(dir->d_name, "..");
I 6
		dir->d_namelen = strlen(dir->d_name);
E 6
		dir->d_reclen = sizeof(dir->d_dnode) + sizeof(dir->d_reclen) + 1 +
				sizeof(dir->d_namelen) + dir->d_namelen + sizeof(dir->d_type);

		/* We are done with the file block now */
		mapfree(fblockaddr);

E 5
		/* Unmap dnode table */
D 4
		munmap(blkaddr, BLOCKSIZE * sb->fs_dtsize);
E 4
I 4
		mapfree(blkaddr);
E 4
	}

E 3
	/* We're done building the first superblock.  unmap the new database and
	 * close its file handle */
D 4
	munmap(baseaddr, sizeof(superblock));
	close(dbfd);
E 4
I 4
	mapfree(baseaddr);
	closemapfile(dbfd);
E 4

	return KESUCCESS;
I 3
}

/* dbinitdb
 * 	Create a new database.  This creates the default root player and other
 * 	important objects
 */
I 4
koalaerror dbinitdb(char *dbpath)
{
D 6
	/* For now, the only think to be done is the newfs */
	return dbnewfs(dbpath);
E 6
I 6
	koalaerror kerr;
	int dbfd;
	void *baseaddr;
	void *dnodebase;
	void *blkbase;
	dnode *dn;
	superblock *sb;
	kdb_dirent *dir;
	struct timeval tod;

I 9
	/* log message */
	logmsg("Creating new root database file system");

E 9
	/* Create a new filesytem on the given database file */
	if ((kerr = dbnewfs(dbpath)) != KESUCCESS)
	{
		logerr("Problem writing new filesystem");
		return KEDBFATAL;
	}

	/* Now that we have the new filesystem, we have to reopen the database */
	if ((dbfd = open(dbpath, O_RDWR)) == -1)
	{
		/* Error reopening database file?  How'd that happen */
		logerr("Unable to reopen database file.");
		return KEDBFATAL;
	}

	/* Map the superblock */
	if ((baseaddr = mmapblockaligned(dbfd, 0, 1)) == NULL)
	{
		logerr("Failed to map to superblock");
		closemapfile(dbfd);
		return KEDBFATAL;
	}
	sb = baseaddr;

	/* Map to the dnode table */
	if ((dnodebase = mmapblockaligned(dbfd, sb->fs_dbno, sb->fs_dtsize)) == NULL)
	{
		logerr("Failed to map to dnode table");
		closemapfile(dbfd);
		return KEDBFATAL;
	}

	/* Create /players/ tree */
	{
		/* Point to the /players/ dnode */
		dn = dnodebase + DNODE_PLAYERS * sizeof(dnode);
		dn->d_nodetype = DNTYPE_DIRECTORY;
		dn->d_links = 3;
		dn->d_size = 512;
		dn->d_blocks = 1;

		/* Set owners */
		dn->d_uid = DNODE_ROOTOWN;
		dn->d_gid = DNODE_ROOTOWN;

		/* Allocate blocks for root directory */
		dn->d_db[0] = allocateblock(dbfd, sb);

		/* Timestamp root node */
		gettimeofday(&tod, NULL);
		dn->d_ctime = dn->d_atime = dn->d_mtime = tod.tv_sec;
		dn->d_ctimesec = dn->d_atimesec = dn->d_mtimesec = tod.tv_usec;

		/* Map to the file block */
		blkbase = mmapblockaligned(dbfd, dn->d_db[0], 1);

		/* Now we need to write out the base directory structure */
		dir = blkbase;
		dir->d_dnode = dn->d_num;
		dir->d_type = DE_DIR;
		strcpy(dir->d_name, ".");
		dir->d_namelen = strlen(dir->d_name);
		dir->d_reclen = sizeof(dir->d_dnode) + sizeof(dir->d_reclen) + 1 +
				sizeof(dir->d_namelen) + dir->d_namelen + sizeof(dir->d_type);

		dir = (void*)dir + dir->d_reclen + 1;
		dir->d_dnode = DNODE_ROOT;
		strcpy(dir->d_name, "..");
		dir->d_namelen = strlen(dir->d_name);
		dir->d_type = DE_DIR;
		dir->d_reclen = sizeof(dir->d_dnode) + sizeof(dir->d_reclen) + 1 +
				sizeof(dir->d_namelen) + dir->d_namelen + sizeof(dir->d_type);

		dir = (void*)dir + dir->d_reclen + 1;
		dir->d_dnode = DNODE_ROOTOWN;
		dir->d_type = DE_DIR;
		strcpy(dir->d_name, "root");
		dir->d_namelen = strlen(dir->d_name);
		dir->d_reclen = sizeof(dir->d_dnode) + sizeof(dir->d_reclen) + 1 +
				sizeof(dir->d_namelen) + dir->d_namelen + sizeof(dir->d_type);

		/* We are done with the file block now */
		mapfree(blkbase);
	}

	/* Create /players/root/ tree */
	{
		/* Point to the /players/ dnode */
		dn = dnodebase + DNODE_ROOTOWN * sizeof(dnode);
		dn->d_nodetype = DNTYPE_DIRECTORY;
D 7
		dn->d_links = 3;
E 7
I 7
		dn->d_links = 2;
E 7
		dn->d_size = 512;
		dn->d_blocks = 1;

		/* Set owners */
		dn->d_uid = DNODE_ROOTOWN;
		dn->d_gid = DNODE_ROOTOWN;

		/* Allocate blocks for root directory */
		dn->d_db[0] = allocateblock(dbfd, sb);

		/* Timestamp root node */
		gettimeofday(&tod, NULL);
		dn->d_ctime = dn->d_atime = dn->d_mtime = tod.tv_sec;
		dn->d_ctimesec = dn->d_atimesec = dn->d_mtimesec = tod.tv_usec;

		/* Map to the file block */
		blkbase = mmapblockaligned(dbfd, dn->d_db[0], 1);

		/* Now we need to write out the base directory structure */
		dir = blkbase;
		dir->d_dnode = dn->d_num;
		dir->d_type = DE_DIR;
		strcpy(dir->d_name, ".");
		dir->d_namelen = strlen(dir->d_name);
		dir->d_reclen = sizeof(dir->d_dnode) + sizeof(dir->d_reclen) + 1 +
				sizeof(dir->d_namelen) + dir->d_namelen + sizeof(dir->d_type);

		dir = (void*)dir + dir->d_reclen + 1;
		dir->d_dnode = DNODE_PLAYERS;
		strcpy(dir->d_name, "..");
		dir->d_namelen = strlen(dir->d_name);
		dir->d_type = DE_DIR;
		dir->d_reclen = sizeof(dir->d_dnode) + sizeof(dir->d_reclen) + 1 +
				sizeof(dir->d_namelen) + dir->d_namelen + sizeof(dir->d_type);

		/* We are done with the file block now */
		mapfree(blkbase);
	}

	/* Map /players/ into / */
	{
		/* Point to the appropriate dnode */
		dn = dnodebase + DNODE_ROOT * sizeof(dnode);

		/* Bump up the link count since there is a link from /players to us */
		dn->d_links++;

		/* Map to the directory block */
		blkbase = mmapblockaligned(dbfd, dn->d_db[0], 1);

		/* Point to the first directory entry */
		dir = blkbase;

		/* Find the end of the directory listing */
		while (dir->d_reclen > 0)
		{
			dir = (void*)dir + dir->d_reclen + 1;
		}

		/* Now add a link into players */
		dir->d_dnode = DNODE_PLAYERS;
		strcpy(dir->d_name, "players");
		dir->d_namelen = strlen(dir->d_name);
		dir->d_type = DE_DIR;
		dir->d_reclen = sizeof(dir->d_dnode) + sizeof(dir->d_reclen) + 1 +
				sizeof(dir->d_namelen) + dir->d_namelen + sizeof(dir->d_type);

		mapfree(blkbase);
	}

	/* Close the database file again */
	closemapfile(dbfd);

	/* Return success */
	return KESUCCESS;
E 6
}
E 4

/* zeroblock
 * 	Write out a null block to the file system.  This function takes the file
 * 	descriptor for the database and a block id to zero.  If the file is
 * 	currently too small, the file will be expanded until it has room for our
 * 	block.
 *
 * 	The file descriptors current offset *will* be modified by this function
 *
 * 	Returns error if the write fails
 */
koalaerror zeroblock(int dbfd, kdbfs_blockid_t block)
{
	ssize_t writeret;
	off_t fdoff;
	char blockzero[BLOCKSIZE] = { '\0' };

	/* seek to the location of the block */
	if ((fdoff = lseek(dbfd, block * BLOCKSIZE, SEEK_SET)) != (block*BLOCKSIZE))
	{
		logerr("DBFATAL: Problem seeking to zero new block");
		return KEDBFATAL;
	}

	/* Write out a block of data */
	if ((writeret = write(dbfd, blockzero, BLOCKSIZE)) != BLOCKSIZE)
	{
		logerr("DBFATAL: Problem seeking to zero new block");
		return KEDBFATAL;
	}

	return KESUCCESS;
}

/* allocateblock
 * 	Allocate a free block from the filesystem containing the passed superblock
 * 	and mark it as allocated.  a return of 0 means that no blocks were able to
 * 	be allocated.
 *
 * 	*theoretically* this should only be needed while building the initial
 * 	database.  Normal object storage routines will need a bit more advanced
 * 	form.
 */
kdbfs_blockid_t allocateblock(int dbfd, superblock *sb)
{
D 5
	kdbfs_blockid_t block = sb->fs_ffblock;

E 5
	/* For the time being, (primarily to make this thing work in the first
	 * place) this will just assign the block listed as first free by the
	 * superblock and do housekeeping.
	 */
I 5
	void *blockbitmap = NULL;
	kdbfs_blockid_t block = sb->fs_ffblock;
	u_int8_t	* byte;

	/* Get a pointer to the block bit map */
	blockbitmap = mmapblockaligned(dbfd, sb->fs_btno, sb->fs_btsize);

	/* Check to see if the block reported as the first free is actually free
	 */
	byte = blockbitmap + block/8;

	/* This check really should not fail... */
	if ((*byte & ((u_int8_t)0x80>>block%8)) != 0)
	{
		/* For now we don't handle the case of ffblock pointing to a bad block
		 */
		return 0;
	}

	/* Mask the bit to 1 */
	*byte |= (u_int8_t)0x80 >> block % 8;

	/* Increment the first free block to the next block */
	sb->fs_ffblock++;
	sb->fs_bfree--;
E 5

D 5
	block = sb->fs_ffblock++;
E 5
I 5
	/* Zero out the block */
	zeroblock(dbfd, block);
E 5

D 5
	return 0;
E 5
I 5
	return block;
E 5
E 3
}
E 2
I 1
E 1
