/***************************************************************************
                          knutfrontpanel.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "knutfrontpanel.h"
#include "knutvardata.h"
#include "knutnet.h"

#include <klocale.h>
#include <kapp.h>

#include <qtooltip.h>
#include <qstring.h>
#include <qpaintdevice.h>
#include <qlayout.h>
#include <qlcdnumber.h>
#include <qframe.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qfont.h>
#include <qpalette.h>




#include <math.h>

KNutFrontPanel::KNutFrontPanel( QPalette* const paletteIn, QWidget *parent, const unsigned int flags, QFont* const panelFonts, const char *name) : QFrame( parent, name ), panelFlags(flags) {

  myPalette = paletteIn->copy(); // We must make deep copy of palette
  upsOk = green;
  upsError = red;
  upsBack = white; //backgroundColor();
  typeOfLCDColor=true;
  LCDNumber1 = 0;


  setFrameStyle( QFrame::Box | QFrame::Raised );
  setLineWidth( 2 );
      
  if (panelFonts == 0) {
    panelFont =kapp->font(); // nastavime font systemovy font
    panelBoldFont = kapp->font();
    }
  else {
    panelFont = *panelFonts; // nastavime font
    panelBoldFont = *panelFonts; // pozdeji zmenime
    }
  panelBoldFont.setBold (TRUE);
  panelFont.setBold (FALSE); // Zrusime bold u panelu

  mainLayout = new QVBoxLayout(this);
  mainLayout->setMargin ( 5 );

  textLabel1 = new QLabel( i18n("UPS On line"),this);
  frameOL = new  QFrame (this);
  frameOL->setBackgroundColor(upsBack);
  frameOL->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  frameOL->setMaximumSize(30,20);
  frameOL->setMinimumSize(30,20);
  QToolTip::add(textLabel1,textLabel1->text());

  OLLayout = new QHBoxLayout(mainLayout);
  OLLayout->addWidget(textLabel1);
  OLLayout->addWidget(frameOL);
  OLLayout->setMargin ( 5 );

  textLabel2 = new QLabel( i18n("UPS On battery"), this);
  frameOB = new  QFrame (this);
  frameOB->setBackgroundColor(upsBack);
  frameOB->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  frameOB->setMaximumSize(30,20);
  frameOB->setMinimumSize(30,20);
  QToolTip::add(textLabel2,textLabel2->text());

  OBLayout = new QHBoxLayout(mainLayout);
  OBLayout->addWidget(textLabel2);
  OBLayout->addWidget(frameOB);
  OBLayout->setMargin ( 5 );

  textLabel3 = new QLabel( i18n("UPS Overload"), this);
  frameOVER = new  QFrame (this);
  frameOVER->setBackgroundColor(upsBack);
  frameOVER->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  frameOVER->setMaximumSize(30,20);
  frameOVER->setMinimumSize(30,20);
  QToolTip::add(textLabel3,textLabel3->text());

  OLayout = new QHBoxLayout(mainLayout);
  OLayout->addWidget(textLabel3);
  OLayout->addWidget(frameOVER);
  OLayout->setMargin ( 5 );

  textLabel4 = new QLabel( i18n("UPS Battery low"), this);
  frameLB = new  QFrame (this);
  frameLB->setBackgroundColor(upsBack);
  frameLB->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  frameLB->setMaximumSize(30,20);
  frameLB->setMinimumSize(30,20);
  QToolTip::add(textLabel4,textLabel4->text());

  LBLayout = new QHBoxLayout(mainLayout);
  LBLayout->addWidget(textLabel4);
  LBLayout->addWidget(frameLB);
  LBLayout->setMargin ( 5 );
  
  textLabel5 = new QLabel( i18n("Replace battery"), this);
  frameRB = new  QFrame (this);
  frameRB->setBackgroundColor(upsBack);
  frameRB->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  frameRB->setMaximumSize(30,20);
  frameRB->setMinimumSize(30,20);
  QToolTip::add(textLabel5,textLabel5->text());

  RBLayout = new QHBoxLayout(mainLayout);
  RBLayout->addWidget(textLabel5);
  RBLayout->addWidget(frameRB);
  RBLayout->setMargin ( 5 );

  textLabel6 = new QLabel( i18n("UPS calibration"), this);
  frameCAL = new  QFrame (this);
  frameCAL->setBackgroundColor(upsBack);
  frameCAL->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  frameCAL->setMaximumSize(30,20);
  frameCAL->setMinimumSize(30,20);
  QToolTip::add(textLabel6,textLabel6->text());

  CALLayout = new QHBoxLayout(mainLayout);
  CALLayout->addWidget(textLabel6);
  CALLayout->addWidget(frameCAL);
  CALLayout->setMargin ( 5 );

  textLabel7 = new QLabel( "", this);
  QToolTip::add(textLabel7,textLabel7->text());
  manufacModelLayout = new QHBoxLayout(mainLayout);
  manufacModelLayout->addWidget(textLabel7);
  manufacModelLayout->setMargin ( 5 );

  textLabelManufac = new QLabel( i18n("Manufac. : "), this);
  textLabel8 = new QLabel( "", this);
  QToolTip::add(textLabelManufac,textLabelManufac->text());

  manufacLayout = new QHBoxLayout(mainLayout);
  manufacLayout->addWidget(textLabelManufac);
  manufacLayout->addWidget(textLabel8);
  manufacLayout->addStretch(20);
  manufacLayout->setMargin ( 5 );

  textLabelName = new QLabel( i18n("Name")+" : ", this);
  textLabel9 = new QLabel( "", this);
  QToolTip::add(textLabelName,textLabelName->text());

  nameLayout = new QHBoxLayout(mainLayout);
  nameLayout->addWidget(textLabelName);
  nameLayout->addWidget(textLabel9);
  nameLayout->addStretch(20);
  nameLayout->setMargin ( 5 );

  textLabelSerial = new QLabel( i18n("Serial : "), this);
  textLabel10 = new QLabel( "", this);
  QToolTip::add(textLabelSerial,textLabelSerial->text());

  serialLayout = new QHBoxLayout(mainLayout);
  serialLayout->addWidget(textLabelSerial);
  serialLayout->addWidget(textLabel10);
  serialLayout->addStretch(20);
  serialLayout->setMargin ( 5 );

  textLabelFirm = new QLabel( i18n("Firm. rev. : "), this);
  textLabel11 = new QLabel( "", this);
  QToolTip::add(textLabelFirm,textLabelFirm->text());

  firmLayout = new QHBoxLayout(mainLayout);
  firmLayout->addWidget(textLabelFirm);
  firmLayout->addWidget(textLabel11);
  firmLayout->addStretch(20);
  firmLayout->setMargin ( 5 );
  
  textLabelRun = new QLabel( i18n("Runtime")+" : ", this);
  QToolTip::add(textLabelRun,textLabelRun->text());

   LCDNumber1 = new QLCDNumber (5,this);
   LCDNumber1->setSegmentStyle (QLCDNumber::Flat);
   LCDNumber1->setFrameStyle( QFrame::NoFrame );
   LCDNumber1->setMinimumSize(50,20);

  runLayout = new QHBoxLayout(mainLayout);
  runLayout->addWidget(textLabelRun);
  runLayout->addStretch(20);
  runLayout->addWidget(LCDNumber1);
  runLayout->setMargin ( 5 );

  mainLayout->addStretch(20);
  mainLayout->addSpacing(5);

  setAllPalettes();

  changePanelFont();
  paintPanel ();

  }

KNutFrontPanel::~KNutFrontPanel(){
  }


//************************************************************

void KNutFrontPanel::paintPanel( void ) {

  if (panelFlags & knc::PBOnLine) {
    textLabel1->show();
    frameOL->show();
    }
  else {
    textLabel1->hide();
    frameOL->hide();
    }

  if (panelFlags & knc::PBOnBatt) {
    textLabel2->show();
    frameOB->show();
    }
  else {
    textLabel2->hide();
    frameOB->hide();
    }

  if (panelFlags & knc::PBOver) {
    OLayout->setMargin ( 5 );
    textLabel3->show();
    frameOVER->show();
    }
  else {
    textLabel3->hide();
    frameOVER->hide();
    OLayout->setMargin ( 0 );
    }

  if (panelFlags & knc::PBBattLow) {
    textLabel4->show();
    frameLB->show();
    LBLayout->setMargin ( 5 );
    }
  else {
    textLabel4->hide();
    frameLB->hide();
    LBLayout->setMargin ( 0 );
    }

  if (panelFlags & knc::PBRepBatt) {
    textLabel5->show();
    frameRB->show();
    RBLayout->setMargin ( 5 );
    }
  else {
    textLabel5->hide();
    frameRB->hide();
    RBLayout->setMargin ( 0 );
    }

  if (panelFlags & knc::PBCal) {
    textLabel6->show();
    frameCAL->show();
    CALLayout->setMargin ( 5 );
    }
  else {
    textLabel6->hide();
    frameCAL->hide();
    CALLayout->setMargin ( 0 );
    }

  if (panelFlags & knc::PBMFRMod) {
    textLabel7->show();
    manufacModelLayout->setMargin ( 5 );
    }
  else {
    textLabel7->hide();
    manufacModelLayout->setMargin ( 0 );
    }


  if (panelFlags & knc::PBMFR) {
    textLabel8->show();
    textLabelManufac->show();
    manufacLayout->setMargin ( 5 );
    }
  else {
    textLabel8->hide();
    textLabelManufac->hide();
    manufacLayout->setMargin ( 0 );
    }

  if (panelFlags & knc::PBModel) {
    textLabel9->show();
    textLabelName->show();
    nameLayout->setMargin ( 5 );
    }
  else {
    textLabel9->hide();
    textLabelName->hide();
    nameLayout->setMargin ( 0 );
    }

  if (panelFlags & knc::PBSerial) {
    textLabel10->show();
    textLabelSerial->show();
    serialLayout->setMargin ( 5 );
    }
  else {
    textLabel10->hide();
    textLabelSerial->hide();
    serialLayout->setMargin ( 0 );
    }

  if (panelFlags & knc::PBFirm) {
    textLabel11->show();
    textLabelFirm->show();
    firmLayout->setMargin ( 5 );
    }
  else {
    textLabel11->hide();
    textLabelFirm->hide();
    firmLayout->setMargin ( 0 );
    }

  if (panelFlags & knc::PBRun) {
    LCDNumber1->show();
    textLabelRun->show();
    runLayout->setMargin ( 5 );
    }
  else {
    LCDNumber1->hide();
    textLabelRun->hide();
    runLayout->setMargin ( 0 );
    }
  }


int KNutFrontPanel::getPanelHeight( void) { return 0; }  ///// correct !!!!!!!!

unsigned int KNutFrontPanel::getPanelFlags( void) { return panelFlags; }

void KNutFrontPanel::setPanelFlags(const int upsPanelFlags) { panelFlags = upsPanelFlags; }

void KNutFrontPanel::setAllNameUps(const QString panelUpsAllName ){
  textLabel7->setText(panelUpsAllName);
  QToolTip::remove(textLabel7);
  QToolTip::add(textLabel7,panelUpsAllName);
  }

void KNutFrontPanel::setMFRUps(const QString panelUpsFRM ){
  textLabel8->setText(panelUpsFRM);
  QToolTip::remove(textLabelManufac);
  QToolTip::add(textLabelManufac,textLabelManufac->text()+panelUpsFRM);
  }

void KNutFrontPanel::setNameUps(const QString panelUpsName ){
  textLabel9->setText(panelUpsName);
  QToolTip::remove(textLabelName);
  QToolTip::add(textLabelName,textLabelName->text()+panelUpsName);
  }

void KNutFrontPanel::setSerialUps(const QString panelUpsSerial ){
  textLabel10->setText(panelUpsSerial);
  QToolTip::remove(textLabelSerial);
  QToolTip::add(textLabelSerial,textLabelSerial->text()+panelUpsSerial);
  }

void KNutFrontPanel::setFirmRevUps(const QString upsPanelFormRev ){
  textLabel11->setText(upsPanelFormRev);
  QToolTip::remove(textLabelFirm);
  QToolTip::add(textLabelFirm,textLabelFirm->text()+upsPanelFormRev);
  }


void KNutFrontPanel::cleanPanel(void) {
  textLabel7->setText("");
  textLabel8->setText("");
  textLabel9->setText("");
  textLabel10->setText("");
  textLabel11->setText("");

  frameOL->setBackgroundColor(upsBack);
  frameOB->setBackgroundColor(upsBack);
  frameOVER->setBackgroundColor(upsBack);
  frameLB->setBackgroundColor(upsBack);
  frameRB->setBackgroundColor(upsBack);
  frameCAL->setBackgroundColor(upsBack);

  LCDNumber1->display("-:--");
  LCDNumber1->setPalette (palette());
  }

void KNutFrontPanel::setRuntime(const int runtime) {
  QString runtimeString;

  if (runtime != knc::numberVarError) {
    int min = (int)floor(runtime/60);
    int sec = runtime - (min*60);
    runtimeString=QString("%1:%2").arg(min,2).arg(sec,2);
    if (runtimeString[3] == ' ') runtimeString[3]='0';
    }
  else runtimeString="-:--";  

  LCDNumber1->display(runtimeString);
  }

  

void KNutFrontPanel::setPanel(const int panelBulbs) {
//  OFF			- 1 ups je vypnuta
//  OL			- 2 ups je bezi na sit
//  OB			- 4 ups bezi na baterie
//  LB			- 8 baterie je vybyta (pokud je zaroven OB dojde k shutdownu)
//  CAL			- 16 je spustena calibrace
//  OVER		- 128 ups je pretizena
//  RB			- 256 ups pozaduje vymenu baterie


  if (!(panelBulbs < 0)) {
    // ups online /na sit
    if (panelBulbs & KNutNet::OL) {
      frameOL->setBackgroundColor(upsOk);
      LCDNumber1->setPalette (LCDPaletteOk);

      typeOfLCDColor=true;
      }
    else frameOL->setBackgroundColor(upsBack);

    // ups ofline /na baterie
    if (panelBulbs & KNutNet::OB) {
      frameOB->setBackgroundColor(upsError);
      LCDNumber1->setPalette (LCDPaletteErr);
      typeOfLCDColor=false;
      }
    else frameOB->setBackgroundColor(upsBack);

    if (panelBulbs & KNutNet::LB) frameLB->setBackgroundColor(upsError);
    else frameLB->setBackgroundColor(upsBack);

    if (panelBulbs & KNutNet::OVER) frameOVER->setBackgroundColor(upsError);
    else frameOVER->setBackgroundColor(upsBack);

    if (panelBulbs & KNutNet::RB) frameRB->setBackgroundColor(upsError);
    else frameRB->setBackgroundColor(upsBack);

   if (panelBulbs & KNutNet::CAL) frameCAL->setBackgroundColor(upsError);
   else frameCAL->setBackgroundColor(upsBack);

    }
  }

void KNutFrontPanel::changePanelFont (void) {
  textLabel1->setFont(panelFont);
  textLabel2->setFont(panelFont);
  textLabel3->setFont(panelFont);
  textLabel4->setFont(panelFont);
  textLabel5->setFont(panelFont);
  textLabel6->setFont(panelFont);

  textLabelManufac->setFont(panelFont);
  textLabelName->setFont (panelFont);
  textLabelSerial->setFont (panelFont);
  textLabelFirm->setFont (panelFont);
  textLabelRun->setFont (panelFont);
  textLabel7->setFont (panelBoldFont);
  textLabel8->setFont (panelBoldFont);
  textLabel9->setFont (panelBoldFont);
  textLabel10->setFont (panelBoldFont);
  textLabel11->setFont (panelBoldFont);
  textLabelRun->setFont (panelFont);
  }

void KNutFrontPanel::slotSetPanelFont(QFont newPanelFont) {

  panelFont = newPanelFont; // nastavime font
  panelBoldFont = newPanelFont; // pozdeji zmenime

  panelBoldFont.setBold (TRUE);
  panelFont.setBold (FALSE); // Zrusime bold u panelu

  changePanelFont(); // zmeni pismo
  paintPanel();
  }

void KNutFrontPanel::setLCDPalette (void) {
  LCDPaletteOk = myPalette;
  LCDPaletteErr = myPalette;
  //Nastavime barvu pro OK system je online
  QColorGroup activeColorGroup = LCDPaletteOk.active();
  activeColorGroup.setColor( QColorGroup::Foreground, green);

  LCDPaletteOk.setActive(activeColorGroup);
  LCDPaletteOk.setInactive(activeColorGroup);

  //Nastavime Barvu pro Error - System neni online
  activeColorGroup = LCDPaletteErr.active();
  activeColorGroup.setColor( QColorGroup::Foreground, red);
  LCDPaletteErr.setActive(activeColorGroup);
  LCDPaletteErr.setInactive(activeColorGroup);

  }

void KNutFrontPanel::setPalette (const QPalette & p){

  myPalette = p;
  setAllPalettes();
  }

      
void KNutFrontPanel::setAllPalettes (void){

  QFrame::setPalette (myPalette);
  LCDPaletteOk = myPalette;
  LCDPaletteErr = myPalette;

  setLCDPalette();
  if (LCDNumber1) {
    if (typeOfLCDColor)
      LCDNumber1->setPalette (LCDPaletteOk);
    else
      LCDNumber1->setPalette (LCDPaletteErr);
    }
  }


  
#include "knutfrontpanel.moc"  
