/***************************************************************************
                          knutnewupsdlg.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutnewupsdlg.h"
 
#include <klocale.h>
#include <kmessagebox.h>

#include <qstring.h>
#include <qlayout.h>
#include <qframe.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>



KNutNewUpsDlg::KNutNewUpsDlg (KNutUpsData* const upsData, KNutVarData* const analogData, const bool add, QWidget* parent, const char* name, const bool modal)
  : KDialogBase(Plain, i18n("New Ups"),Help|Ok|Cancel,Ok, parent, name, modal, true ), addMember(add) {

  myUpsData = upsData;
  setName( "KupsNewUpsDlg" );

  QFrame *page =plainPage();
  QVBoxLayout *mainLayout = new QVBoxLayout( page, 0, spacingHint(), "mainLayout" );
    QHBoxLayout *dataLayout = new QHBoxLayout(mainLayout, spacingHint(),"dataLayout");

    
        QGroupBox *hostBox = new QGroupBox (page,"hostBox");
        QGridLayout *hostLayout = new QGridLayout (hostBox, 5, 2, spacingHint () );
        hostBox->setFrameStyle(QFrame::NoFrame);
        dataLayout->addWidget(hostBox);

          QHBoxLayout *portLayout = new QHBoxLayout(-1,"portLayout");
          hostLayout->addLayout(portLayout,4,1);

          QHBoxLayout *loginLayout = new QHBoxLayout(-1,"loginLayout");
          hostLayout->addLayout(loginLayout,5,1);

        QButtonGroup *protocolGroup = new QButtonGroup(i18n("Protocol"),page,"protocolGroup");
        QGridLayout *protocolLayout = new QGridLayout (protocolGroup, 4 , 1,spacingHint () );

      dataLayout-> addWidget(protocolGroup);

    QGroupBox* GroupBox1 = new QGroupBox( page, "GroupBox1" );
    QGridLayout *varLayout = new QGridLayout (GroupBox1, 7 , 2,spacingHint ());
    
  QLabel* TextLabel1 = new QLabel( i18n("Name")+":",hostBox, "TextLabel1" );
  hostLayout->addWidget (TextLabel1,1,0);
  LineEdit1 = new KLineEdit( hostBox, "LineEdit1" );
  LineEdit1->setEnabled( add ); // pokus se nejedna o pridani (add) neni jmeno aktivovani
  hostLayout->addWidget (LineEdit1,1,1);

  QLabel* TextLabel2 = new QLabel(i18n("UPS address")+":", hostBox, "TextLabel2" );
  hostLayout->addWidget (TextLabel2,2,0);
  LineEdit2 = new KLineEdit( hostBox, "LineEdit2" );
  hostLayout->addWidget (LineEdit2,2,1);

// Name of UPS
  QLabel* TextLabel7 = new QLabel(i18n("UPS name")+":", hostBox, "TextLabel7" );
  hostLayout->addWidget (TextLabel7,3,0);
  LineEdit7 = new KLineEdit( hostBox, "LineEdit7" );
  hostLayout->addWidget (LineEdit7,3,1);

  
  QLabel* TextLabel3 = new QLabel(i18n("Delay (ms):"), hostBox, "TextLabel3" );
  hostLayout->addWidget (TextLabel3,4,0);
  LineEdit3 = new KLineEdit( hostBox, "LineEdit3" );
  LineEdit3->setText("5000");
  portLayout->addWidget(LineEdit3);
  portLayout->addSpacing(10);

  QLabel* TextLabel4 = new QLabel(i18n("Port:"), hostBox, "TextLabel4" );
  LineEdit4 = new KLineEdit( hostBox, "LineEdit4" );
  LineEdit4->setText(QString("%1").arg(knc::DefaultPort));
  portLayout->addWidget(TextLabel4);
  portLayout->addWidget(LineEdit4);

  QLabel* TextLabel5 = new QLabel(i18n("User name:"), hostBox, "TextLabel5" );
  hostLayout->addWidget (TextLabel5,5,0);
  LineEdit5 = new KLineEdit( hostBox, "LineEdit5" );
  LineEdit5->setText("");
  loginLayout->addWidget(LineEdit5);
  loginLayout->addSpacing(10);

  QLabel* TextLabel6 = new QLabel(i18n("Password:"), hostBox, "TextLabel6" );
  LineEdit6 = new KLineEdit( hostBox, "LineEdit6" );
  LineEdit6->setEchoMode(QLineEdit::Password);
  LineEdit6->setText("");
  loginLayout->addWidget(TextLabel6);
  loginLayout->addWidget(LineEdit6);

  savePassword = new QCheckBox (i18n("Store NUT password in configuration file"),page,"savePassword");
  mainLayout->addWidget(savePassword);
  mainLayout->addWidget(GroupBox1);
  mainLayout->addStretch(10);

          
  RadioButton1 = new QRadioButton(i18n("UDP"), protocolGroup, "RadioButton1" );
  RadioButton1->setChecked( FALSE );
  RadioButton2 = new QRadioButton(i18n("TCP"), protocolGroup, "RadioButton2" );
  RadioButton2->setChecked( TRUE );
  protocolLayout->addWidget ( RadioButton1,1,0 );
  protocolLayout->addWidget ( RadioButton2,2,0 );
  protocolLayout->addRowSpacing (3 ,fontMetrics().lineSpacing() );

  GroupBox1->setTitle( i18n( "UPS Variables" ));
  ComboBox1 = new KComboBox( FALSE, GroupBox1, "CB1" );
  ComboBox2 = new KComboBox( FALSE, GroupBox1, "CB2" );
  ComboBox3 = new KComboBox( FALSE, GroupBox1, "CB3" );
  ComboBox4 = new KComboBox( FALSE, GroupBox1, "CB4" );
  ComboBox5 = new KComboBox( FALSE, GroupBox1, "CB5" );
  ComboBox6 = new KComboBox( FALSE, GroupBox1, "CB6" );
  ComboBox7 = new KComboBox( FALSE, GroupBox1, "CB7" );
  ComboBox8 = new KComboBox( FALSE, GroupBox1, "CB8" );
  ComboBox9 = new KComboBox( FALSE, GroupBox1, "CB9" );
  ComboBox10 = new KComboBox( FALSE, GroupBox1, "CB10" );


  varLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  varLayout->addWidget ( ComboBox1,1,0 );
  varLayout->addWidget ( ComboBox2,2,0 );
  varLayout->addWidget ( ComboBox3,3,0 );
  varLayout->addWidget ( ComboBox4,4,0 );
  varLayout->addWidget ( ComboBox5,5,0 );
  varLayout->addWidget ( ComboBox6,1,1 );
  varLayout->addWidget ( ComboBox7,2,1 );
  varLayout->addWidget ( ComboBox8,3,1 );
  varLayout->addWidget ( ComboBox9,4,1 );
  varLayout->addWidget ( ComboBox10,5,1 );
  varLayout->addRowSpacing (6 ,fontMetrics().lineSpacing() );



  for (int i=0; i < knc::NumberOfTypes; i++) {
    ComboBox1->insertItem( analogData->getNameAnalogData(i) );
    ComboBox2->insertItem( analogData->getNameAnalogData(i) );
    ComboBox3->insertItem( analogData->getNameAnalogData(i) );
    ComboBox4->insertItem( analogData->getNameAnalogData(i) );
    ComboBox5->insertItem( analogData->getNameAnalogData(i) );
    ComboBox6->insertItem( analogData->getNameAnalogData(i) );
    ComboBox7->insertItem( analogData->getNameAnalogData(i) );
    ComboBox8->insertItem( analogData->getNameAnalogData(i) );
    ComboBox9->insertItem( analogData->getNameAnalogData(i) );
    ComboBox10->insertItem( analogData->getNameAnalogData(i) );
    }
  slotProtocol(RadioButton2->isChecked());// nastavime User name, Password
  connect (RadioButton2,SIGNAL(toggled(bool)),this,SLOT(slotProtocol(bool)));

  }


void KNutNewUpsDlg::putData (const upsRecord upsInfo ) {
  LineEdit1->setText(upsInfo.name);
  LineEdit2->setText(upsInfo.upsAddress);
  LineEdit7->setText(upsInfo.upsName);
  QString delay, port;
  delay.setNum(upsInfo.delay);
  LineEdit3->setText(delay);
  port.setNum(upsInfo.port);
  LineEdit4->setText(port);
  LineEdit5->setText(upsInfo.userName);
  LineEdit6->setText(upsInfo.password);
  RadioButton1->setChecked( !upsInfo.tcp );
  RadioButton2->setChecked( upsInfo.tcp );
  savePassword->setChecked(savePassword);
  ComboBox1->setCurrentItem(upsInfo.upsVarCode[0]);
  ComboBox2->setCurrentItem(upsInfo.upsVarCode[1]);
  ComboBox3->setCurrentItem(upsInfo.upsVarCode[2]);
  ComboBox4->setCurrentItem(upsInfo.upsVarCode[3]);
  ComboBox5->setCurrentItem(upsInfo.upsVarCode[4]);
  ComboBox6->setCurrentItem(upsInfo.upsVarCode[5]);
  ComboBox7->setCurrentItem(upsInfo.upsVarCode[6]);
  ComboBox8->setCurrentItem(upsInfo.upsVarCode[7]);
  ComboBox9->setCurrentItem(upsInfo.upsVarCode[8]);
  ComboBox10->setCurrentItem(upsInfo.upsVarCode[9]);
  }


void KNutNewUpsDlg::getData (upsRecord& upsInfo ) {
  upsInfo.name=LineEdit1->text();
  upsInfo.upsAddress=LineEdit2->text();
  upsInfo.upsName=LineEdit7->text();
  upsInfo.delay=LineEdit3->text().toLong();
  upsInfo.port=LineEdit4->text().toUInt();
  upsInfo.tcp=RadioButton2->isChecked();
  upsInfo.userName=LineEdit5->text();
  upsInfo.password=LineEdit6->text();
  upsInfo.savePassword=savePassword->isChecked();
  upsInfo.upsVarCode[0]=ComboBox1->currentItem();
  upsInfo.upsVarCode[1]=ComboBox2->currentItem();
  upsInfo.upsVarCode[2]=ComboBox3->currentItem();
  upsInfo.upsVarCode[3]=ComboBox4->currentItem();
  upsInfo.upsVarCode[4]=ComboBox5->currentItem();
  upsInfo.upsVarCode[5]=ComboBox6->currentItem();
  upsInfo.upsVarCode[6]=ComboBox7->currentItem();
  upsInfo.upsVarCode[7]=ComboBox8->currentItem();
  upsInfo.upsVarCode[8]=ComboBox9->currentItem();
  upsInfo.upsVarCode[9]=ComboBox10->currentItem();
 }


void KNutNewUpsDlg::slotOk() {
  bool ok;
  // zavreme okno
  LineEdit1->setText(LineEdit1->text().stripWhiteSpace());
  LineEdit2->setText(LineEdit2->text().stripWhiteSpace());

  if ((LineEdit1->text().length() <1 )
  || (LineEdit2->text().length() <1 )) {
    KMessageBox::sorry (0,i18n("No Name or UPS address"));
    return;
    }

  if (addMember) {
    // pokud UpsName jiz existuje nemuzeme vytvorit novy zaznam
    if ( myUpsData->findName(LineEdit1->text()) != 0L ) {
    KMessageBox::sorry (0,i18n("This Name exist"));
    return;
    }
  }

  long delay = LineEdit3->text().toLong(&ok);
  if (! ok) {
    KMessageBox::sorry (0,i18n("Delay must be number"));
    return;
    }

  long port = LineEdit4->text().toLong(&ok);
  if (! ok) {
    KMessageBox::sorry (0,i18n("Port must be number"));
    return;
    }

  if ((port < knc::StartPort) || (port > knc::StopPort)) {
    KMessageBox::sorry (0,i18n("Port must be from 1025 until 65535"));
    return;
    }

  if (delay < knc::MinDelay) {
    KMessageBox::sorry (0,i18n("Delay is too small"));
    return;
    }
  accept ();
  }

void KNutNewUpsDlg::slotProtocol(bool tcp) {
  LineEdit5->setEnabled(tcp);
  LineEdit6->setEnabled(tcp);
  savePassword->setEnabled(tcp);
  } 

KNutNewUpsDlg::~KNutNewUpsDlg() {
  }

#include "knutnewupsdlg.moc"
