// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.13 $

//***********************************************
//***  hk_kdeform PART definition             ***
//***********************************************
#include "hk_kdeformpart.h"
#include "hk_kdeformpartfactory.h"
#include "hk_kdesimpleform.h"
#include <kinstance.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kaction.h>
#include <klocale.h>
#include <kurl.h>
#include <kactionclasses.h>
#include <kparts/partmanager.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qcombobox.h>
#include <hk_drivermanager.h>
#include <hk_connection.h>
#include <hk_database.h>
#include <hk_datasource.h>
#include "hk_kdetoolbar.h"
class hk_kdeformpartprivate
{
  public:
  hk_kdeformpartprivate()
  	{
		p_form=NULL;
		activate=false;
	}
   hk_kdeformpartwidget* p_form;
   bool activate;
};

hk_kdeformpart::hk_kdeformpart(QWidget* pWidget, const char* /*widgetname*/,QObject* parent, const char* name, const QStringList &)
:KParts::ReadWritePart(parent,name)
{
    p_private=new hk_kdeformpartprivate;
    setInstance(hk_kdeformpartfactory::instance());
    setXMLFile(locate("data","hk_kdeclasses/hk_kdeformpartdesign.rc"));
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");

    p_private->p_form = new hk_kdeformpartwidget(this,pWidget,0,WDestructiveClose);
    setWidget(p_private->p_form);

}

hk_kdeformpart::~hk_kdeformpart()
{
  if (widget())
  {
    if (p_private->p_form->simpleform()->has_changed())
      p_private->p_form->simpleform()->save_form();
  }
  delete p_private;
}



/*void hk_kdeformpart::show_dbdesignercolumndialog(void)
{
    p_private->p_table->simpledbdesigner()->show_dbdesignercolumndialog();
}*/


void hk_kdeformpart::setReadWrite(bool rw)
{
    KParts::ReadWritePart::setReadWrite(rw);
}


bool hk_kdeformpart::openFile()
{
 // URL handling:   mysql:/user:password@host:port/databasename/datasourcetype/datasourcename
 // where datasourcetype is either tables or queries


    return true;
}


bool hk_kdeformpart::saveFile()
{
    return true;
}




void hk_kdeformpart::setXMLFile(const QString& file,bool merge,bool setxmldoc)
{
  KParts::ReadWritePart::setXMLFile(file,merge,setxmldoc);
if (manager()&&manager()->activePart()==this&&! p_private->activate)
{

  p_private->activate=true;
  //manager()->blockSignals(true);
  manager()->setActivePart(NULL);
  //manager()->blockSignals(false);
  manager()->setActivePart(this);
  p_private->activate=false;
}
}









KAboutData* hk_kdeformpart::createAboutData()
{
    KAboutData* a= new KAboutData("hk_kdeformpart", I18N_NOOP("hk_kdeformpart"),
        "0.1", I18N_NOOP("database form editor"),
        KAboutData::License_GPL,"(c) 2002-2004, Horst Knorr <hk_classes@knoda.org>");

    return a;

}






