// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.4 $

//***********************************************
//***  hk_kdetable PART definition             ***
//***********************************************
#include "hk_kdetablepart.h"
#include "hk_kdetablepartfactory.h"
#include <kinstance.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kaction.h>
#include <klocale.h>
#include <kurl.h>
#include <kactionclasses.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qcombobox.h>
#include <hk_drivermanager.h>
#include <hk_connection.h>
#include <hk_database.h>
#include <hk_datasource.h>
#include "hk_kdegrid.h"
#include "hk_kdesimplegrid.h"
#include "hk_kdetabledesign.h"
#include "hk_kdetoolbar.h"

class hk_kdetablepartprivate
{
  public:
  hk_kdetablepartprivate()
  	{
		p_table=NULL;
	}
   hk_kdetablepartwidget* p_table;
};

hk_kdetablepart::hk_kdetablepart(QWidget* pWidget, const char* /*widgetname*/,QObject* parent, const char* name, const QStringList &)
:KParts::ReadWritePart(parent,name)
{
    p_private=new hk_kdetablepartprivate;
    setInstance(hk_kdetablepartfactory::instance());
    p_private->p_table = new hk_kdetablepartwidget(pWidget,0,WDestructiveClose);
    setWidget(p_private->p_table);
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    p_private->p_table->p_printaction=new KAction(i18n("&Print"),"fileprint",0,p_private->p_table->kdegrid(),SLOT(print_grid()),actionCollection(),"print");
    p_private->p_table->p_printaction->setEnabled(false);
    if (p_private->p_table->runtime_only())
    {
     p_private->p_table->p_designaction=NULL;
     p_private->p_table->p_viewaction=NULL;
     p_private->p_table->p_saveaction=NULL;
     
    }
    else
    {
    p_private->p_table->p_designaction=new KRadioAction(i18n("&Design mode"),"edit",0,p_private->p_table,SLOT(designbutton_clicked()),actionCollection(),"designmode");
    p_private->p_table->p_designaction->setEnabled(!p_private->p_table->runtime_only());
    p_private->p_table->p_viewaction=new KRadioAction(i18n("&View mode"),"exec",0,p_private->p_table,SLOT(tablebutton_clicked()),actionCollection(),"viewmode");
    p_private->p_table->p_designaction->setExclusiveGroup("mode");
    p_private->p_table->p_viewaction->setExclusiveGroup("mode");
    p_private->p_table->p_saveaction=new KAction(i18n("Save"),"filesave",0,p_private->p_table,SLOT(save_table()),actionCollection(),"save");
    p_private->p_table->p_saveaction->setEnabled(false);
    }
    p_private->p_table->p_filterdefinitionaction=new KAction(i18n("Filterdefinition"),loader->loadIcon("filter",KIcon::User),0,p_private->p_table->toolbar(),SLOT(filterdefinebutton_clicked()),actionCollection(),"filterdefinition");
    p_private->p_table->p_filterexecaction=new KToggleAction(i18n("Filterexecution"),loader->loadIcon("filterexec",KIcon::User),0,p_private->p_table->toolbar(),SLOT(filterexecbutton_clicked()),actionCollection(),"filterexec");
    
    p_private->p_table->toolbar()->set_filteractions(p_private->p_table->p_filterdefinitionaction,p_private->p_table->p_filterexecaction);
    
    p_private->p_table->p_columndialogaction = new KAction(i18n("&Gridcolumns"),loader->loadIcon("grid22x22",KIcon::User),0,p_private->p_table->kdegrid()->simplegrid(),SLOT(show_gridcolumndialog()),actionCollection(),"gridcolumn");
    p_private->p_table->p_columndialogaction->setEnabled(!hk_class::runtime_only());
    
    p_private->p_table->p_copyaction = new KAction(i18n("&Copy"),"editcopy",CTRL+Key_C,p_private->p_table->kdegrid()->simplegrid(),SLOT(copy()),actionCollection(),"copy");
    p_private->p_table->p_pasteaction = new KAction(i18n("&Paste"),"editpaste",CTRL+Key_V,p_private->p_table->kdegrid()->simplegrid(),SLOT(paste()),actionCollection(),"paste");
    p_private->p_table->p_findaction = new KAction(i18n("&Find in columns"),loader->loadIcon("find",KIcon::User),0,p_private->p_table->kdegrid(),SLOT(find_clicked()),actionCollection(),"findcolumn");

     setXMLFile(locate("data","hk_kdeclasses/hk_kdetablepart.rc"));

}

hk_kdetablepart::~hk_kdetablepart()
{
  if (widget())
  {
    p_private->p_table->p_design->alter_table(true);
  }
  
  delete p_private;
}



/*void hk_kdetablepart::show_dbdesignercolumndialog(void)
{
    p_private->p_table->simpledbdesigner()->show_dbdesignercolumndialog();
}*/


void hk_kdetablepart::setReadWrite(bool rw)
{
    KParts::ReadWritePart::setReadWrite(rw);
}


bool hk_kdetablepart::openFile()
{
 // URL handling:   mysql:/user:password@host:port/databasename/datasourcetype/datasourcename
 // where datasourcetype is either tables or queries


    return true;
}


bool hk_kdetablepart::saveFile()
{
    return true;
}







KAboutData* hk_kdetablepart::createAboutData()
{
    KAboutData* a= new KAboutData("hk_kdetablepart", I18N_NOOP("hk_kdetablepart"),
        "0.1", I18N_NOOP("database table editor"),
        KAboutData::License_GPL,"(c) 2002-2004, Horst Knorr <hk_classes@knoda.org>");

    return a;

}






