//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruletargetoptioneditmark.h"


// QT includes
#include <qstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../interfaces/kmfruleeditinterface.h"
#include "kmfruleedittargetmark.h"


KMFRuleTargetOptionEditMark::KMFRuleTargetOptionEditMark(QObject *parent, const char *name)
		: KMFRuleTargetOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleTargetOptionEditMark::KMFRuleTargetOptionEditMark(QObject *parent, const char *name)" << endl;
	
	m_managedTargets << "MARK";
	
	
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditTargetMark( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,SIGNAL(sigAddRuleOpt(QString*, QPtrList< QString >* ) ), 
		this,SLOT( slotAddRuleOption(QString*, QPtrList< QString >* ) ) );
	connect( m_edit,SIGNAL(sigAddTargetOpt(QString*, QPtrList< QString >* ) ), 
		this,SLOT( slotAddTargetOption(QString*, QPtrList< QString >* ) ) );
	connect( m_edit,SIGNAL(sigHideMe() ), 
		this,SLOT( slotShowOverview() ) );
}

KMFRuleTargetOptionEditMark::~KMFRuleTargetOptionEditMark() {}

void KMFRuleTargetOptionEditMark::slotAddRuleOption(QString* name, QPtrList< QString >* values ) {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->addRuleOption( name, values );
	} else {
		kdDebug() << "KMFRuleTargetOptionEditMark::slotAddRuleOption(): parent() not of type KMFRuleEditInterface" << endl;
	}
}
void KMFRuleTargetOptionEditMark::slotAddTargetOption(QString* name, QPtrList< QString >* values ) {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->addRuleTargetOption( name, values );
	} else {
		kdDebug() << "KMFRuleTargetOptionEditMark::slotAddTargetOption(): parent() not of type KMFRuleEditInterface" << endl;
	}
}
void KMFRuleTargetOptionEditMark::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleTargetOptionEditMark::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}


const QString& KMFRuleTargetOptionEditMark::optionEditName() const {
	return *( new QString( i18n("NAT Option") ) );
}
const QString& KMFRuleTargetOptionEditMark::description() const {
	return *( new QString( i18n("This plugin manages the NAT options of iptables.") ) );
}

void KMFRuleTargetOptionEditMark::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleTargetOptionEditMark::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

QWidget* KMFRuleTargetOptionEditMark::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleTargetOptionEditMark::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}

bool KMFRuleTargetOptionEditMark::setTarget( const QString& target ){
	if ( ! manageTarget( target ) ) {
		return false;
	}
	return true;
}



// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFRuleTargetOptionEditMarkFactory::s_instance = 0L;
// KAboutData* KMFRuleTargetOptionEditMarkFactory::s_about = 0L;

KMFRuleTargetOptionEditMarkFactory::KMFRuleTargetOptionEditMarkFactory( QObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFRuleTargetOptionEditMarkFactory" );
}

QObject* KMFRuleTargetOptionEditMarkFactory::createObject( QObject* parent, const char* name,
        const char*, const QStringList & ) {
	QObject * obj = new KMFRuleTargetOptionEditMark( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFRuleTargetOptionEditMarkFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFRuleTargetOptionEditMarkFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruletargetoptionedit_mark() {
		return new KMFRuleTargetOptionEditMarkFactory;
	}
}




#include "kmfruletargetoptioneditmark.moc"
