/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
/*
Author: Christian Hubinger <chubinger@gmail.com>, (C) 2001-2004
*/


#ifndef KMYFIREWALL_H
#define KMYFIREWALL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qwidget.h>

// KDE includes
#include <kapplication.h>
#include <kmainwindow.h>
#include <kprocess.h>
#include <kconfig.h>
#include <kurl.h>
#include <kparts/mainwindow.h>
#include <kparts/dockmainwindow.h>
#include <ktempfile.h>

// Project includes
#include "kmfwidgets/kmfmainwindow.h"
#include "interfaces/kmyfirewallinterface.h"

class KAction;
class KActionMenu;
class KDockWidget;
class KMFDoc;
class KMFIPTDoc;
class KMFGenericDoc;
class KMFView;
class KMFError;
class KMFErrorHandler;
class KMFIPTDocOptions;
class KMFConfigDialog;
class KMFRuleEdit;
class KMFCompilerPlugin;
class QCloseEvent;
class QStringList;
class KMFProcOut;
class QWidgetStack;
class KMFSelectInterface;
class KTempFile;
/** KMyFirewall is the base class of the project */
class KMyFirewall : public KMFMainWindow {
	Q_OBJECT

public:
	KMyFirewall( QWidget* parent = 0, const char *name = 0 );
	~KMyFirewall();
	KMFDoc* doc();

	void showEditor();
	void showOutput();
	void setOutputWidget( QWidget* );
	void checkStatus();

public slots:    // Public slots
	void slotUndo();
	void slotRedo();
	void slotFileSaveAs();
	void slotFileSaveAsTemplate();
	void slotFileOpen();
	void slotFileNew();
	void slotFileClose();
	void slotConfigureToolbars();
	void slotNewToolbarConfig();
	void slotEditDocInfo();
	void slotEnableSave();
	void slotLoadDocument( KMFDoc* );
	void slotRestoreSession();
	void slotConfigureKMF();
/*	void slotStartWizard();*/
	void slotLoadEmptyRuleset();
  	void slotLoadTemplate();
	void slotLoadFile( const QString& );
	void toggleActions( bool );
	void slotEnableUndo( bool );
	void slotEnableRedo( bool );
	bool hasOpenDoc();
	void slotQuitApp();
	void slotReloadDocument();
	void slotConfigChanged();
	void slotSelectInterface();


	
protected:
	bool checkRoot();
	void updateView();
	
protected slots:
	void initMenu();
	void initStatusBar();
	void initView();
	void initDoc();
	void initActions();
	void slotFileSave();
	void toggleToolBar();
	void toggleStatusBar();
	void slotShowEditor();
	void slotProcessExited( KProcess* );
	void slotReceivedOutput( KProcess*, char*, int );
	void slotReceivedError( KProcess*, char*, int );

private:    // member functions
	bool isTemplate();
	void saveDocument( bool isTemplate );
	KMFError* parseDocument( const KURL& );
	KMFError* saveDocument( const KURL& );
	//++++++++++++++

private:    // data
	QWidget* m_editorWidget;
	KProcess* childproc;
	KProcess &operator<<( const QString& arg );
	QString m_processName;
	KTempFile *m_iptables_saveOutput;
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;
	KMFDoc* kmfdoc;
	KMFConfigDialog *m_configDlg;
	KMFSelectInterface *m_selInterface;
	
	KAction* actionQuit;
	KAction* actionNew;
	KAction* actionClose;
	KAction* actionOpen;
	KAction* actionSave;
	KAction* actionSaveAs;
	KAction* actionEditDocInfo;
	KAction* actionLoadTemplate;
	KAction* actionUndo;
	KAction* actionRedo;

	bool saveQuit();
	void closeEvent ( QCloseEvent * );
	QWidgetStack* m_widgetStack;
	QWidget *m_outputWidget;

signals:
	void documentChanged( KMFIPTDoc * );
	void processExited( KProcess * );
	void sigSplashShow( bool );
	void sigSplashShowMsg( const QString& );
};

#endif
