//
// C++ Interface: kmfnetworkwidget
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFNETWORKWIDGET_H
#define KMFNETWORKWIDGET_H

#include "kmyfirewallnetworkwidget.h"

// QT includes
#include <qwidget.h>

// KDE includes
#include <kdemacros.h>

// project includes
#include "../core/kmfnetzone.h"
#include "../core/ipaddress.h"

/**
@author Christian Hubinger
*/
class KDE_EXPORT KMFNetworkWidget : public KMyFirewallNetworkWidget {
	Q_OBJECT
public:
	KMFNetworkWidget(QWidget *parent = 0, const char *name = 0);
	~KMFNetworkWidget();
	
	void loadZone( KMFNetZone* );
	void allowEdit( bool );
private slots:
	void slotAddressChanged( const QString& );
	void slotLongMaskChanged( const QString& );
	void slotShortMaskChanged( int );
	
private:
	void blockAllSignals( bool );	

private:
	KMFNetZone *m_zone;
	bool m_allowEdit;

signals:
	void sigZoneChanged( KMFNetZone* );
};

#endif
