/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Interface: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFRULEOPTIONEDITSTATE_H
#define KMFRULEOPTIONEDITSTATE_H

#include "../../interfaces/kmfruleoptioneditinterface.h"

// KDE includes
#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>


class IPTRule;
class KMFRuleEditorState;
/**
@author Christian Hubinger
*/
class KMFRuleOptionEditState : public KMFRuleOptionEditInterface {
	Q_OBJECT
public:
	KMFRuleOptionEditState(QObject *parent = 0, const char *name = 0);

	~KMFRuleOptionEditState();
	void loadRule( IPTRule* rule );	
	QWidget* editWidget();
	const QString& optionEditName() const;
	const QString& description() const;

private slots:
	void slotAddRuleOption(QString*, QPtrList< QString >* );
	void slotAddTargetOption(QString*, QPtrList< QString >* );
	void slotShowOverview();

private:
	KMFRuleEditorState *m_edit;
	IPTRule *m_rule;
	
};

class KInstance;

class KMFRuleOptionEditStateFactory : public KLibFactory {
	Q_OBJECT
public:
	KMFRuleOptionEditStateFactory( QObject *parent = 0, const char *name = 0 );
	virtual ~KMFRuleOptionEditStateFactory() {
/* 		delete s_instance; */
	};
	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
	                               const char* name = "QObject",
	                               const QStringList &args = QStringList() );
	/*     static KInstance* instance(); */

/*private:
	static KInstance* s_instance;*/
};









#endif
