/* -*- c++ -*-
 *
 * sharepage.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_sharepage_h__
#define __kmldonkey_sharepage_h__

#include <qobject.h>
#include <qvbox.h>
#include <qintdict.h>

#include "clipboard.h"
#include "page.h"

class QTimer;
class KActionCollection;

class KMLDonkeyPreferences;
class InfoList;

class SharedFile : public InfoItem
{
public:
    SharedFile( KListView *parent, int share ) : InfoItem(parent,share) { refresh(); }
    ~SharedFile() {}

    QString xtext(int col) const;
    double numeric(int col ) const;
    bool isNumeric(int col) const;

};

class UploadersFile : public InfoItem
{
public:
    UploadersFile(KListView *parent, int uploaderid) : InfoItem(parent,uploaderid) {}
    ~UploadersFile() {}

    QString xtext(int col) const;
    double numeric(int col) const;
    bool isNumeric(int col) const;
};

class SharePage : public QVBox, public KMLDonkeyPage, public ClipboardHelper
{
    Q_OBJECT
public:
    SharePage(QWidget* parent = 0);

    virtual void setupActions(KActionCollection*);
    virtual QStringList supportedGenericActions();
    virtual void handleGenericAction(const QString&);
    virtual void plugGenericActions(QObject*, const char*);
    virtual void deactivatePageActions();

    virtual void configurePrefsDialog(KMLDonkeyPreferences* prefs);
    virtual void applyPreferences(KMLDonkeyPreferences* prefs = 0);
    virtual void saveState(KConfig* conf);
    virtual void restoreState(KConfig* conf);

    virtual void clear();

    //void clearUploadersView();
    //void addUploadersViewItem(QMap<QString, QString> items);

signals:
    void genericActionsChanged(KMLDonkeyPage*);

public slots:
    void shareUpdated(int share);
    void shareRemoved(int share);

protected slots:
    void contextUpload(KListView*,QListViewItem*,const QPoint&);
    void actionRefreshShared();
    void actionSharedDirs();

    void contextUploaders(KListView*,QListViewItem*,const QPoint&);
    void actionRefreshUploaders();

    void actionUpdateUploader(int clientnum);
    void actionRemoveUploader(int clientnum);

    void actionActivatePage();

    void clearUploadSelection();
    void clearUploadersSelection();

    void refreshLists();
    void updateTimer();

protected:
    void showEvent(QShowEvent* event);

private:
    void copyFileToClipboard(ClipFormat format);

    QSplitter *uploadSplitter;
    InfoList *uploadView, *uploadersView;

    QIntDict<SharedFile> shareList;
    QIntDict<UploadersFile> uploadList;

    QPtrList<KAction> uploadActions, uploadersActions;
    KAction * refreshShared, * refreshUploaders;

    QTimer* refreshTimer;
    bool autoUpdate;
    int updateFrequency, activeFrequency;
};

#endif
