/* -*- c++ -*-
 *
 * renamedialog.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "renamedialog.h"
#include "infolist.h"

#include <kglobal.h>
#include <kconfig.h>
#include <klocale.h>
#include <kdebug.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <qlayout.h>
#include <qlabel.h>

#include <fileinfo.h>

RenameDialog::RenameDialog(DonkeyProtocol* protocol, int file)
    : KDialogBase(Plain, i18n("Select File Name"),
                  Help|Default|Try|Ok|Cancel, Ok)
{
    donkey = protocol;
    fileno = file;
    FileInfo* fi = donkey->findDownloadFileNo(fileno);
    if (!fi) return;

    setButtonText(Try, i18n("&Preview"));
    setButtonTip(Try, i18n("Ask MLDonkey to preview the file."));

    QFrame *frame = plainPage();
    QGridLayout* layout = new QGridLayout(frame, 5, 2, 6);

    layout->addWidget(new QLabel(i18n("Name:"), frame), 0, 0);
    layout->addWidget(new QLabel(i18n("Size:"), frame), 1, 0);
    layout->addWidget(new QLabel(i18n("Hash:"), frame), 2, 0);
    layout->addWidget(new QLabel(i18n("Format:"), frame), 3, 0);
    layout->addWidget(new QLabel(i18n("New name:"), frame), 4, 0);

    nameView = new KLineEdit(fi->fileName(), frame, "nameView");
    nameView->setReadOnly(true);
    layout->addWidget(nameView, 0, 1);

    sizeView = new KLineEdit(humanReadableSize(fi->fileSize()), frame, "sizeView");
    sizeView->setReadOnly(true);
    layout->addWidget(sizeView, 1, 1);

    hashView = new KLineEdit(fi->fileUid(), frame, "hashView");
    hashView->setReadOnly(true);
    layout->addWidget(hashView, 2, 1);

    formatView = new KLineEdit(fi->fileFormatInfo(), frame, "formatView");
    formatView->setReadOnly(true);
    layout->addWidget(formatView, 3, 1);

    nameEdit = new KComboBox(frame, "nameEdit");
    nameEdit->setEditable(true);
    nameEdit->insertStringList(fi->fileNames());
    nameEdit->setCurrentText(fi->fileName());
    layout->addWidget(nameEdit, 4, 1);
}

void RenameDialog::slotDefault()
{
    FileInfo* fi = donkey->findDownloadFileNo(fileno);
    if (!fi) return;
    nameEdit->setCurrentText(fi->fileName());
}

void RenameDialog::slotTry()
{
    donkey->previewFile(fileno);
}

void RenameDialog::slotOk()
{
    QString foo = nameEdit->currentText();
    emit renameFile(fileno, foo);
    KDialogBase::slotOk();
}

#include "renamedialog.moc"
