/***************************************************************************
                          filetransferp2p.h -  description
                             -------------------
    begin                : Sun 12 19 2004
    copyright            : (C) 2004 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILETRANSFERP2P_H
#define FILETRANSFERP2P_H

#include "p2papplication.h"

#include <qstring.h>
#include <qobject.h>

class MsnObject;
class MimeMessage;
class P2PMessage;
class QFile;
class TransferEntry;


/**
 * An application class responsable for P2P file transfers between clients.
 *
 * @author Diederik van der Boor
 */
class FileTransferP2P : public P2PApplication
{
  Q_OBJECT

  public:
    // The constructor without filename (sufficient for incoming sessions)
                           FileTransferP2P(const QString &localIP, const QString &contactHandle);
    // The constructor with filename to start a session
                           FileTransferP2P(const QString &localIP, const QString &contactHandle, const QString &filename);

    // The destructor
    virtual               ~FileTransferP2P();

    // Return the application's GUID
    static QString         getAppId();


  private:

    // Step one of a contact-started chat: the contact invites the user
    void                   contactStarted1_ContactInvitesUser(const MimeMessage& message);
    // Step two of a contact-started chat: the user accepts
    void                   contactStarted2_UserAccepts();
    // Step three of a contact-started chat: the contact confirms the accept
    void                   contactStarted3_ContactConfirmsAccept(const MimeMessage& message);
    // Step four of a contact-started chat: the contact confirms the data-preparation message.
    void                   contactStarted4_ContactConfirmsPreparation();
    // End the application with another message in the file transfer dialog as well (The "failTransfer"-like method)
    void                   endApplication(const QString &reason, const QString &transferDialogMessage);
    // Called when data is received
    void                   gotData(const P2PMessage &message);
    // Show the file transfer dialog
    void                   initializeProgressDialog(bool incoming, uint filesize);

    // Step one of a user-started chat: the user invites the contact
    void                   userStarted1_UserInvitesContact();
    // Step two of a user-started chat: the contact accepts
    void                   userStarted2_ContactAccepts(const MimeMessage &message);
    // Step three of a user-started chat: the user prepares for the session
    void                   userStarted3_UserPrepares();


  private slots:
    // Cancel the file transfer
    void                   slotCancelTransfer();


  private:
    // Handle of the file.
    QFile                 *file_;
    // Name of the file where the data should be stored.
    QString                fileName_;
    // The size of the file
    unsigned int           fileSize_;
    // The suggested file name
    QString                suggestedFileName_;
    // The file transfer progress dialog
    TransferEntry         *transferPanel_;
};

#endif
