/***************************************************************************
                          contactonlinenotification.h  -  description
                             -------------------
    begin                : Thu Jan 30 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTONLINENOTIFICATION_H
#define CONTACTONLINENOTIFICATION_H

#include <qwidget.h>
#include "popupnotification.h"

// Forward declarations
class Contact;
class KMessTest;
class BalloonWidget;
class NotificationWidget;
class QStringList;

/**This is the popup when a contact comes online.
  *@author Mike K. Bennett
  */

class ContactOnlineNotification : public QObject
{
  Q_OBJECT

  friend class KMessTest;

  public:
    // The constructor
               ContactOnlineNotification( BalloonWidget *balloonWidget );
    // The destructor
              ~ContactOnlineNotification();

  public slots:
    // Called when a contact comes online
    void       contactOnline(Contact *contact, bool showBaloon);

  private slots: // Private slots
    // The balloon was clicked
    void       clicked( QStringList stringList, QObject *object );

  private: // Private attributes
    // Balloon Widget
    BalloonWidget      *balloonWidget_;
    // The handle of the contact shown
    QString             handle_;
    // Not. Widget
    NotificationWidget *notificationWidget_;

  signals: // Public signals
    // Start a chat with the contact
    void       startChat( QString contactHandle );
};

#endif
