/***************************************************************************
                          contactdrag.cpp  -  description
                             -------------------
    begin                : Sat 22 Mar 2003
    copyright            : (C) 2003 by Michael Curtis.
    email                : mdcurtis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTDRAG_H
#define CONTACTDRAG_H

#include <qdragobject.h>

namespace ContactDragInfo
{
  const char mimeType[] = "application/x-kmess-contact";
}

class ContactDragObject : public QDragObject
{
  public:
    // the constructor
    ContactDragObject( QWidget *dragSource = 0, const char * name = 0 );
    // the destructor
    ~ContactDragObject();

   // return the mimetype provided by its index number
   const char * format ( int index = 0 ) const;
   // return a boolean value indicating whether we can return this mimetype
   bool provides ( const char * mimeType ) const;
   // decodes the mime data in the format given
   QByteArray encodedData ( const char * mimeType ) const;
};

#endif
