/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef HEADER_H
#define HEADER_H

#include <qmap.h>
#include <qstringlist.h>

#include "globals.h"

/**
@author Alessandro Bonometti
*/

typedef QMap<int,int> ServerNumMap;

// Now there are way MANY fields in the header....

class Header {


private:
    uchar* insert(QString, uchar*);
    uchar* retrieve(uchar*,QString &);
	bool ok;
    //     uchar* retrieve(QString, uchar*);




public:
    QString m_from;
    QString m_subj;
    QString m_lines;
    QString m_mid;
    QString m_bytes;
    QString m_date;
    int status;
	int m_num;

    ServerNumMap serverNum;
    ServerNumMap::iterator it;

    uint size();
    uint keysize();
    uchar *data();
	bool isOk() {return ok;}
    Header(uchar *);
	
    
    
    Header(NntpHost *, QStringList);
	Header(QStringList);
	Header(QString);
	Header(char *);
// 	Header(char *);
    //     void getindex();



};


#endif
