/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "mylistview.h"
#include "globals.h" 


MyListView::MyListView( ) : KListView()
{
	
}






bool MyListView::acceptDrag( QDropEvent *e ) const
{
	
	QPoint p=contentsToViewport(e->pos());
	
	
	QListViewItem *item = itemAt( p );
// 	if (item && (item->depth() != 0 || item->itemBelow()->depth() != 0) ) {
	if (item) {
		if (item->depth() != 0) {
// 			kdDebug() << "Item: " << item->text(0) << endl;
			return  false;
		} else if ( (item=item->itemBelow()) != 0 ) {
			if (item->depth() != 0) {
// 				kdDebug() << "Item: " << item->text(0) << endl;
				return false;
			} else {
// 				kdDebug() << "Item: " << item->text(0) << endl;
				return true;
			}
	
// 		kdDebug() << "item: " << item->text(0) << endl;
		
		} else return true;
	}
	
	
	return false;
}


