/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kitty_prefs.h"
#include <klocale.h>
#include <qlayout.h>
#include <qlabel.h>
#include <kiconloader.h>
#include <qcheckbox.h>
#include <qvbox.h>
#include <qradiobutton.h>
#include <klineedit.h>
#include <kmessagebox.h>
#include <qbuttongroup.h>
#include <kstandarddirs.h>
#include <qcombobox.h>
#include <qdir.h>
#include <qgrid.h>
#include <keditlistbox.h>

Kitty_prefs::Kitty_prefs(QObject *parent, const char *name)
 : KDialogBase(IconList, i18n("Kitty Preferences"),
                  Ok|Cancel, Ok)
{
QString str;
    QFrame *frame;

    frame = addVBoxPage(i18n("Behaviour"), i18n("Behaviour Options"),DesktopIcon("kitty"));
    chk_open_on_click=new QCheckBox(i18n("Autorefresh empty feeds on click."),frame);
    chk_download_on_collect=new QCheckBox(i18n("Autodownload content when added to my collection."),frame);
    chk_start_minimized=new QCheckBox(i18n("Start Kitty minimised on tray."),frame);
    chk_restart_partial=new QCheckBox(i18n("Restart partially downloaded media at startup."),frame);
    chk_autosubmit_feed=new QCheckBox(i18n("Automatically submit new subscribed feeds to the Kitty's guide."),frame);
    QLabel *sepa=new QLabel(frame);
    sepa->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    // --------------------------------
    

    frame = addVBoxPage(i18n("Bittorrent"), i18n("Bittorrent Options"),DesktopIcon("bottom"));
    new QLabel(i18n("Bittorrent text-only client"),frame);
    btclient=new KLineEdit(frame);
    QLabel *sepb=new QLabel(frame);
    sepb->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    // --------------------------------

    frame = addVBoxPage(i18n("Interface"), i18n("Interface Options"),DesktopIcon("colors"));
    new QLabel(i18n("Interface style"),frame);
    radio_std=new QRadioButton(i18n("Standard KDE interface"),frame,"model");
    radio_html=new QRadioButton(i18n("HTML skinnable interface"),frame,"model");
    new QLabel(i18n("HTML skin"),frame);
    cmb_skin=new QComboBox(frame);

    cmb_skin->insertItem(i18n("Built-in skin"));
    QString search=locateLocal("appdata","skins/");
    QDir d(search);
    d.setFilter( QDir::Dirs );
    d.setSorting( QDir::Name );
    const QFileInfoList *list = d.entryInfoList();
    QFileInfoListIterator it( *list );
    QFileInfo *fi;
    while ( (fi = it.current()) != 0 ) {
	QString fname=fi->fileName().latin1();
	if (fname.left(1)!=".") {
		cmb_skin->insertItem(fname);
	}
            ++it;
    }

    new QLabel(i18n("<b>Notes:</b> Skins are into <i>%1</i>").arg(search),frame);
    QLabel *sepz=new QLabel(frame);
    sepz->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    connect(radio_std,SIGNAL(clicked()),this,SLOT(set_std()));
    connect(radio_html,SIGNAL(clicked()),this,SLOT(set_html()));
    // --------------------------------

    frame = addVBoxPage(i18n("Publish"), i18n("Publishing Options"),DesktopIcon("make_kdevelop"));
    new QLabel(i18n("Publish your collection"),frame);
    radio_nopub=new QRadioButton(i18n("Disabled"),frame,"pub");
    radio_pub=new QRadioButton(i18n("Enabled"),frame,"pub");
    new QLabel(i18n("Publishing destination"),frame);

    QGrid *grid=new QGrid(2,frame);
    grid->setSpacing(KDialog::spacingHint());
    new QLabel(i18n("Host"),grid);
    pub_hostname=new KLineEdit(grid);
    new QLabel("",grid);
    new QLabel(i18n("<i>Example:</i> <b>ftp://</b>www.host.com/folder/"),grid);
    new QLabel(i18n("User name"),grid);
    pub_username=new KLineEdit(grid);
    new QLabel(i18n("Password"),grid);
    pub_password=new KLineEdit(grid);
    pub_password->setEchoMode(QLineEdit::Password);
    new QLabel(i18n("Public address"),grid);
    pub_pub_hostname=new KLineEdit(grid);
    new QLabel("",grid);
    new QLabel(i18n("<i>Example:</i> <b>http://</b>www.host.com/folder/"),grid);
    new QLabel("",grid);
    chk_pub_movies=new QCheckBox(i18n("Publish also the movies."),grid);
    new QLabel("",grid);
    chk_pub_thumbs=new QCheckBox(i18n("Publish also the thumbnails."),grid);
    new QLabel("",grid);
    new QLabel(i18n("If checked, the local movies or local thumbnails will be uploaded to the server.<br>If disabled, it will be kept the original URL."),grid);
    new QLabel("",grid);
    chk_publish_update_guide=new QCheckBox(i18n("Updates the Kitty's guide after publish."),grid);

    sepz=new QLabel(frame);
    sepz->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);

    connect(radio_pub,SIGNAL(clicked()),this,SLOT(set_pub()));
    connect(radio_nopub,SIGNAL(clicked()),this,SLOT(set_nopub()));
    // --------------------------------

    frame = addVBoxPage(i18n("Audio"), i18n("Audio streams extensions"),DesktopIcon("multimedia"));
    new QLabel(i18n("Add here your audio streaming formats.<br>Files with this extension will be opened without switching to the media page.<br>Should be useful when listening audio podcasts and keep the HTML interface."),frame);
    editExtension=new KEditListBox(i18n("Audio formats"),frame);
    // --------------------------------

    frame = addVBoxPage(i18n("Guide"), i18n("Guide advanced Options"),DesktopIcon("contents"));

    new QLabel(i18n("Trapped URL argument id for subscribe"),frame);
    chk_trap_var=new KLineEdit(frame);

    new QLabel(i18n("Trapped URL argument value for subscribe"),frame);
    chk_trap=new KLineEdit(frame);

    new QLabel(i18n("Trapped URL argument id for subscribing suburl"),frame);
    chk_url_var=new KLineEdit(frame);
    QLabel *sepc=new QLabel(frame);
    sepc->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    // --------------------------------

     
}



Kitty_prefs::~Kitty_prefs()
{
}

void Kitty_prefs::set_pub() {
	radio_pub->setChecked(true);
	radio_nopub->setChecked(false);
	pub_hostname->setEnabled(true);
	pub_username->setEnabled(true);
	pub_password->setEnabled(true);
	chk_pub_movies->setEnabled(true);
	chk_pub_thumbs->setEnabled(true);
	chk_publish_update_guide->setEnabled(true);
	pub_pub_hostname->setEnabled(true);
}

void Kitty_prefs::set_nopub() {
	radio_nopub->setChecked(true);
	radio_pub->setChecked(false);
	pub_hostname->setEnabled(false);
	pub_username->setEnabled(false);
	pub_password->setEnabled(false);
	chk_pub_movies->setEnabled(false);
	chk_pub_thumbs->setEnabled(false);
	pub_pub_hostname->setEnabled(false);
	chk_publish_update_guide->setEnabled(false);
}

void Kitty_prefs::set_std() {
	radio_html->setChecked(false);
	radio_std->setChecked(true);
	cmb_skin->setEnabled(false);
}

void Kitty_prefs::set_html() {
	radio_std->setChecked(false);
	radio_html->setChecked(true);
	cmb_skin->setEnabled(true);
}

void Kitty_prefs::updateWidgets() {
    chk_open_on_click->setChecked(localsettings.set_open_on_click);
    chk_download_on_collect->setChecked(localsettings.set_download_on_collect);
    chk_start_minimized->setChecked(localsettings.start_minimized);
    chk_restart_partial->setChecked(localsettings.restart_partial);
    chk_autosubmit_feed->setChecked(localsettings.autosubmit_feed);
    chk_trap_var->setText(localsettings.trap_var);
    chk_trap->setText(localsettings.trap);
    chk_url_var->setText(localsettings.url_var);

    radio_std->setChecked(localsettings.interface==0);
    radio_html->setChecked(localsettings.interface==1);
    btclient->setText(localsettings.bittorrent_client);
    if (localsettings.interface==1) set_html(); else set_std();
    if (localsettings.skin.isEmpty()) {
	cmb_skin->setCurrentItem(0);
    } else {
	cmb_skin->setCurrentText(localsettings.skin);
    }

    editExtension->insertStringList(localsettings.audioExtensions);
    radio_pub->setChecked(localsettings.publishenabled==0);
    radio_nopub->setChecked(localsettings.publishenabled==1);
    pub_username->setText(localsettings.username);
    pub_password->setText(localsettings.password);
    pub_hostname->setText(localsettings.hostname);
    pub_pub_hostname->setText(localsettings.pub_hostname);
    if (localsettings.publishenabled==1) set_pub(); else set_nopub();
    chk_pub_movies->setChecked(localsettings.publish_movies);
    chk_pub_thumbs->setChecked(localsettings.publish_thumbs);
    chk_publish_update_guide->setChecked(localsettings.publish_update_guide);
}

void Kitty_prefs::slotOk() {
	localsettings.set_open_on_click=chk_open_on_click->isChecked();
	localsettings.set_download_on_collect=chk_download_on_collect->isChecked();
	localsettings.start_minimized=chk_start_minimized->isChecked();
	localsettings.restart_partial=chk_restart_partial->isChecked();
	localsettings.autosubmit_feed=chk_autosubmit_feed->isChecked();
	localsettings.trap_var=chk_trap_var->text();
	localsettings.trap=chk_trap->text();
	localsettings.url_var=chk_url_var->text();
	localsettings.bittorrent_client=btclient->text();
	localsettings.audioExtensions=editExtension->items();
	if (radio_std->isChecked()) { localsettings.interface=0; }
	if (radio_html->isChecked()) { localsettings.interface=1; }
	if (cmb_skin->currentItem()==0) {
		localsettings.skin="";
	} else {
		localsettings.skin=cmb_skin->currentText();
	}

	if (radio_pub->isChecked()) { localsettings.publishenabled=1; }
	if (radio_nopub->isChecked()) { localsettings.publishenabled=0; }
	localsettings.hostname=pub_hostname->text();
	localsettings.username=pub_username->text();
	localsettings.password=pub_password->text();
	localsettings.pub_hostname=pub_pub_hostname->text();
	if (!localsettings.hostname.isEmpty() && localsettings.hostname.right(1)!="/") localsettings.hostname+="/"; 
	if (!localsettings.pub_hostname.isEmpty() && localsettings.pub_hostname.right(1)!="/") localsettings.pub_hostname+="/"; 
	localsettings.publish_movies=chk_pub_movies->isChecked();
	localsettings.publish_thumbs=chk_pub_thumbs->isChecked();
	localsettings.publish_update_guide=chk_publish_update_guide->isChecked();

 	accept();
}

#include "kitty_prefs.moc"
