/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KITTY_ARTICLEEDIT_H
#define KITTY_ARTICLEEDIT_H

#include <qwidget.h>
#include <kdialogbase.h>
#include "kitty_feedmodel.h"
#include <qlineedit.h>
#include <qtextedit.h>
#include <kurllabel.h>
#include <kio/job.h>

/**
@author KesieV
*/
class kitty_articleedit : public KDialogBase
{
Q_OBJECT
public:
    kitty_articleedit( QWidget *parent, const QString& caption,const t_feed& feed,const int &article);

    ~kitty_articleedit();

    bool getChanged() { return changed; }
    t_feed getFeed() { return myfeed; }

private slots:
	void slot_playvideo();
	void slot_setvideo();
	void slot_delvideo();
	void slot_setthumb();
	void slot_delthumb();
	void slotresult (KIO::Job *);

private:
	void setThumbnail();
	void setVideo();
	void commit_changes();
	virtual void slotOk();

	t_feed myfeed;
	int myarticle;
	QString videourl;
	QString oldvideourl;
	QString thumburl;
	QString oldthumburl;

	QLineEdit *title;
	QLineEdit *author;
	QLineEdit *thumbnail;
	QLineEdit *homepage;
	QLineEdit *file;
	QTextEdit *description;
 	QLabel *thumblabel ;
 	KURLLabel *videolabel ;
	int commit_step;
	bool changed;

};

#endif
