/***************************************************************************
 *   Copyright (C) 2003 by Sylvain Joyeux                                  *
 *   sylvain.joyeux@m4x.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef RPM_H
#define RPM_H

#ifdef USE_RPM

#include "packagemanager.h"
#include <kprocio.h>

class Rpm : public PackageManager
{
  Q_OBJECT

  typedef void (Rpm::*ReceiveMethod) (const QStringList& lines);
  ReceiveMethod m_receive;

  KProcIO m_process;
  QString m_buffer;
  QString ffile;
  
private slots:
  void readReady(KProcIO* io);

private:
  void receiveSearch(const QStringList& line);
  void receiveList(const QStringList& line);

public:
  Rpm(QObject *parent = 0, const char *name = 0);
  ~Rpm();

  virtual int capabilities(int query) const;
  virtual bool list(const QString& package);
  virtual bool search(const QString& file);
  virtual QString getOnlineForm();

};
#endif // USE_RPM

#endif
