#!/bin/sh

usage()
{
	# Title
	echo "Title: XviD MPEG-4 AVI Single Pass (MEncoder)"

	# Usable?
	command -v mencoder 1> /dev/null 2>&1
	[ $? -eq 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: single-pass file-producer

	# Profiles
	echo "Profile:  4:3 High Quality (640x480, VBR, QPEL)"
	echo "Profile:  4:3 Medium Quality (320x240, VBR)"
	echo "Profile:  4:3 Broadband Quality (320x240, 564 kb/s)"
	echo "Profile: 16:9 High Quality (640x360, VBR, QPEL)"
	echo "Profile: 16:9 Medium Quality (320x180, VBR)"
	echo "Profile: 16:9 Broadband Quality (320x180, 564 kb/s)"
}

execute()
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"

	# generate filename if missing
	[ "x$file" = "x" ] && file="kino_export_"`date +%Y-%m-%d_%H.%M.%S`

	# Run the command
	# Note that the -cache 8192 parameter is required to force mencoder
	# to recognize the DV stream on STDIN.
	case "$profile" in 
		"0" )   mencoder - -quiet -cache 8192 -aspect 4:3 -xy 640 -zoom -vf harddup,pp=ci,scale -ovc xvid -oac mp3lame -lameopts preset=standard -xvidencopts fixed_quant=2:qpel -o "$file".avi ;;
		"1" ) 	mencoder - -quiet -cache 8192 -aspect 4:3 -xy 320 -zoom -vf harddup,pp=ci,scale -af-adv force=1 -srate 44100 -ovc xvid -oac mp3lame -lameopts preset=medium -xvidencopts fixed_quant=4 -o "$file".avi ;;
		"2" ) 	mencoder - -quiet -cache 8192 -aspect 4:3 -xy 320 -zoom -vf harddup,pp=ci,scale -af-adv force=1 -srate 32000 -ovc xvid -oac mp3lame -lameopts preset=64 -xvidencopts bitrate=500 -o "$file".avi ;;
		"3" )   mencoder - -quiet -cache 8192 -aspect 16:9 -xy 640 -zoom -vf harddup,pp=ci,scale -ovc xvid -oac mp3lame -lameopts preset=standard -xvidencopts fixed_quant=2:qpel -o "$file".avi ;;
		"4" ) 	mencoder - -quiet -cache 8192 -aspect 16:9 -xy 320 -zoom -vf harddup,pp=ci,scale -af-adv force=1 -srate 44100 -ovc xvid -oac mp3lame -lameopts preset=medium -xvidencopts fixed_quant=4 -o "$file".avi ;;
		"5" ) 	mencoder - -quiet -cache 8192 -aspect 16:9 -xy 320 -zoom -vf harddup,pp=ci,scale -af-adv force=1 -srate 32000 -ovc xvid -oac mp3lame -lameopts preset=64 -xvidencopts bitrate=500 -o "$file".avi ;;
	esac
}

[ "$1" = "--usage" ] || [ -z "$1" ] && usage "$@" || execute "$@"
