/*
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <sys/time.h>

#include <iostream>

extern "C"
{

#include "callbacks.h"
#include "interface.h"
#include "support.h"

    static GtkWidget *progress = NULL;
    static GtkWidget *bar = NULL;
    static bool hidden = true;
    static long long createTime, lastUpdateTime;
    static bool canceled = false;

    void CreateProgressDialog() {

        struct timeval tv;

        progress = create_progress_dialog();
        bar = lookup_widget(progress, "progress_dialog_progressbar");
        gettimeofday(&tv, 0);
        createTime = 1000000 * tv.tv_sec + tv.tv_usec;
        lastUpdateTime = createTime;
        canceled = false;
        hidden = true;
            gtk_widget_show(progress);
    }


    int UpdateProgressDialog(gfloat val, gfloat delay) {
        struct timeval tv;
        long long now;

        gettimeofday(&tv, 0);
        now = 1000000 * tv.tv_sec + tv.tv_usec;

        /* show progress dialog if we are not done after 2 seconds */

        if ((hidden == true) && ((now - createTime) > (delay * 1000000))) {
            gtk_widget_show(progress);
            hidden = false;
        }

        /* update every 0.3 second */
    
        if (val < 0.0) val = 0;
        if (val > 1.0) val = 1.0;

        if (hidden == false && now > lastUpdateTime + 300000) {
            gtk_progress_bar_update(GTK_PROGRESS_BAR(bar), val);
            lastUpdateTime = now;
        }
        //if (gtk_events_pending()) {
			//printf( "looping...\n" );
            //gtk_main_iteration();
			//printf( "looped...\n" );
		//}

        return canceled == true;
    }


    void CloseProgressDialog() {

        gtk_widget_destroy(progress);
        progress = NULL;
        bar = NULL;
    }


    void
    on_progress_dialog_cancel_clicked (GtkButton *button,
                                       gpointer user_data) {
        canceled = true;
    }

}
