
#include "libdv.h"

pthread_mutex_t LibDV::mutex = PTHREAD_MUTEX_INITIALIZER;

dv_decoder_t *LibDV::DV_decoder_new() {
	lock();
	dv_decoder_t *ret = dv_decoder_new();
	unlock();
	return ret;
}

void LibDV::DV_init( ) {
	lock();
	dv_init();
	unlock();
}

gint LibDV::DV_parse_header( dv_decoder_t *dv, guchar *buffer ) {
	lock();
	gint ret = dv_parse_header( dv, buffer );
	unlock();
	return ret;
}

void LibDV::DV_decode_full_frame( dv_decoder_t *dv, 
			  	guchar *buffer, dv_color_space_t color_space, 
			  	guchar **pixels, gint *pitches ) {
	lock();
	dv_decode_full_frame( dv, buffer, color_space, pixels, pitches );
	unlock();
}

gint LibDV::DV_decode_full_audio(dv_decoder_t *dv, 
			  	guchar *buffer, gint16 **outbufs) {
	lock();
	gint ret = dv_decode_full_audio( dv, buffer, outbufs );
	unlock();
	return ret;
}

void LibDV::DV_decode_video_segment(dv_decoder_t *dv, 
				dv_videosegment_t *seg, guint quality ) {
	lock();
	dv_decode_video_segment( dv, seg, quality );
	unlock();
}

void LibDV::DV_render_video_segment_rgb(dv_decoder_t *dv, 
				dv_videosegment_t *seg, 
				guchar **pixels, gint *pitches) {
	lock();
	dv_render_video_segment_rgb( dv, seg, pixels, pitches );
	unlock();
}

void LibDV::DV_render_video_segment_yuv(dv_decoder_t *dv, 
				dv_videosegment_t *seg, 
				guchar **pixels, gint *pitches) {
	lock();
	dv_render_video_segment_yuv( dv, seg, pixels, pitches );
	unlock();
}

int LibDV::DV_frame_changed (dv_decoder_t *dv) {
	lock();
	int ret = dv_frame_changed( dv );
	unlock();
	return ret;
}

int LibDV::DV_frame_is_color (dv_decoder_t *dv) {
	lock();
	int ret = dv_frame_is_color( dv );
	unlock();
	return ret;
}

int LibDV::DV_system_50_fields (dv_decoder_t *dv) {
	lock();
	int ret = dv_system_50_fields( dv );
	unlock();
	return ret;
}

int LibDV::DV_format_normal (dv_decoder_t *dv) {
	lock();
	int ret = dv_format_normal( dv );
	unlock();
	return ret;
}

int LibDV::DV_format_wide (dv_decoder_t *dv) {
	lock();
	int ret = dv_format_wide( dv );
	unlock();
	return ret;
}

int LibDV::DV_get_vaux_pack (dv_decoder_t *dv, 
				guint8 pack_id, guint8 *pack_data) {
	lock();
	int ret = dv_get_vaux_pack( dv, pack_id, pack_data ) ;
	unlock();
	return ret;
}

