/***************************************************************************
                                  setup.h
                             -------------------
    begin                : Thu Feb 17 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : ben-dev@csh.rit.edu
 ***************************************************************************/

#ifndef SETUP_H
#define SETUP_H

#include <qdict.h>
#include <qmap.h>
#include "kinkattalistview.h"
#include "tbuddylist.h"
#include "newpounceimp.h"

class QMultiLineEdit;
class QString;

/**
 * Settings for all of kinkatta
 * Will be fazed out over time to kconfig.
 */
struct settings_t {		
  QString config;
    
  // Sound
  int SoundMode;
  bool sound_enable_login;
  bool sound_enable_logout;
  QString sound_file_command;
  QString sound_file_login;
  QString sound_file_logout;
 	
  // Network
  QString login_server_toc;
  QString login_server_login;
  QString login_port_toc;
  QString login_port_login;
  bool login_enable_save;
  bool login_enable_auto;		
  QString login_name;			
  QString login_password;		
  int proxy_Choice;
  QString proxy_server;
  QString proxy_port;
  	
  // Permit Deny
 
  // Away
  bool away_enable_auto;
  int away_auto_delay_minutes;
  QString away_auto_default_message;
  QMap <QString, QString> *mapAwayMessages;
  bool away_comeBackOnlyOnBackClick;
  bool away_disable_sound;
		
  // General
  bool main_resizeHeight;
  int main_resizeHeightMax;
  int main_resizeHeightMin;
  bool main_resizeWidth;
  int main_resizeWidthMax;
  int main_resizeWidthMin;
  bool main_loginMoveRight;
  bool main_loginMoveLeft;
  bool main_loginMoveNo;
  int main_moveDown;
  bool main_showIdle;
  bool main_showLastOn;
  bool main_noIcons;
  int main_idleLayout;
  bool main_noHeader;
  bool main_useX11ForIdle;
  bool main_showTraySignonTooltip;
  int main_traySignonTooltipPosX;
  int main_traySignonTooltipPosY;
  int main_traySignonTooltipAnchorPosition;
  bool main_mute_on_login;

  // Chat Settings
  /// Kinkattalistview.h
  buddylist_Font_Settings *buddylistFontSettings;

  bool ignore_automated_get_away;
			
  QString IgnoreThisUpdate;
  int xSize;
  int ySize;
  QDict<pounce> pounces;

  // Internal Settings (not to be saved)
  QString Version;
  QString ReleaseDate;
  QString Language;
};

/**
  *@author Benjamin Meyer
  */

class setup {
	
public:
  setup();
  ~setup();
  static setup *instance();
  static settings_t *settings();
				
  void save();
  void read();
  void removeGroup(QString group);
  void resetDefaults();
  void savePounces(const QString &user, const QDict<pounce> &list);
  QDict<pounce> readPounces(const QString &user);

  QString readPassword(const QString &user);
  QString decryptPassword(const QString &cryptedPass);
  QString cryptPassword(const QString &plainPass);
  void savePassword(const QString &user, const QString &password);
  void removePassword(const QString &user);
  QStringList registeredUsers(void);
  bool isRegisteredUser(QString &user);
  QString readProfile(const QString &user);
  void saveProfile(const QString &user, const QString &profile);
  void saveBuddyList(const QString &user, 
  const TBuddyList *buddyList, 
  const TBuddyList *permitList, 
  const TBuddyList *denyList, int permitStatus);
  void parseBuddyList(const QString &user, 
  TBuddyList *buddyList, 
  TBuddyList *permitList, 
  TBuddyList *denyList, int *permitStatus);
  void parseBuddyListFile(const QString &settingsFileXml, 
  TBuddyList *buddyList, 
  TBuddyList *permitList, 
  TBuddyList *denyList, int *permitStatus);
  QString buddyListFileToString(const QString &file);
  QString buddyListToString(const QString &user);
  QString buddyListToString(const TBuddyList *buddyList, 
  const TBuddyList *permitList, 
  const TBuddyList *denyList, int permitStatus);
  //XXX: temporary
  void convertOldFilesToNewFiles(void);

private:
  QString KDEHOMEDIR;
  settings_t *i_currentSettings;

};

#endif

// setup.h

