/***************************************************************************
                                 rot13.h
                             -------------------
    begin                : Saturday Dec 1 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef KINKATTAPLUGINROT13_H
#define KINKATTAPLUGINROT13_H

#include <kinkattachatplugin.h>

class Configure;
class Chat;

/**
 * The very first plugin for Kinkatta.  The rot13 plugin will encrypt and 
 * decrypt messages.  The only option is the number that can be used to rot
 * the message with.  Messages are send out with a "rot13(...)" around the
 * message.  Any incoming message that has a "rot13(...)" around it will be
 * decrypted before being sent through the system.
 * @author Benjamin Meyer
 */

class Rot13 : public KinkattaChatPlugin {

Q_OBJECT
	
signals:

public:
  /// Constructor.
  Rot13(QWidget *parent=0, const char *name=0);
  
  /// Destructor.
  virtual ~Rot13();

public slots:
  /// Requests the the configure widget for this plugin.
  virtual QWidget *configure( QWidget *parent );	

  /// Get the settings from the configure widget and apply them.
  virtual void applyConfigure();
 
  /// A message has come from the network for this plugin to handle.
  virtual void inChatMessage( QString buddy, QString message, bool isAuto );

  /// A message in going out for this plugin to handle.
  virtual void outChatMessage( QString buddy, QString message, bool isAuto, bool endIdleNess );
  
  /// After this plugin has been initialized this function is called.
  virtual void initPlugin();

  /// When it is time to save settings this function is called.
  virtual void saveSettings();

protected:
  /// Encrypts a message.
  QString encrypt( const QString &plainMessage );

  /// Decrypts a message.
  QString decrypt( const QString &cryptedMessage );

  /// The number that determines the encryption.
  int roundNumber;

  /// This plugin's configure widget.
  Configure *configureWidget;

};

#endif

// rot13.h

