/***************************************************************************
                                rot13.cpp 
                           -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "rot13.h"
#include "configure.h"
#include "chat.h"
#include "crypt.xpm"
#include <qspinbox.h>
#include <qdir.h>
#include "preferences.h"

extern "C"
{
  void* create_plugin()
  {
    return new Rot13;
  }
};

/**
 * Constructor.  Initializes the plugin info and settings.
 * @param parent the parent widget
 * @param name the name of this widget
 */
Rot13::Rot13(QWidget *parent, const char *name) : KinkattaChatPlugin( parent,name ){
  info.Name = "Rot13 Encryption";
  info.Author = "Benjamin Meyer";
  info.Version = "1.00";
  info.HomePage = "http://kinkatta.sourceforge.net/";

  roundNumber = 13;
  configureWidget = NULL;
  QPixmap c(crypt);
  image = c;
}

/**
 * Deconstructor.
 */
Rot13::~Rot13(){
}

/**
 * Reads in the settings.
 */
void Rot13::initPlugin(){
  KinkattaChatPlugin::initPlugin();

  // Read Settings.
  QString DirStr = QDir::homeDirPath() + "/.kinkatta/plugins/rot13.settings" ;
  Preferences prefs(DirStr, info.Name, info.Version);
  roundNumber = prefs.getNumber("rot13Number", 13);
}
 
/**
 * Gets the current value of the settings from the configure widget.
 */
void Rot13::applyConfigure(){
  if( configureWidget != NULL ) {
    roundNumber = configureWidget->spinBoxValue->value();
  }
}

/**
 * Creates the configure widget if there isn't one.
 * @param parent the parent widget for the configure widget if one needs to be made.
 * @return QWidget the configure widget for this plugin.
 */
QWidget *Rot13::configure( QWidget *parent ){
  if ( configureWidget == NULL )
    configureWidget = new Configure(parent, "Rot13 Configure window.");
  configureWidget->spinBoxValue->setValue(roundNumber);
  return configureWidget;
}	

/**
 * Checks the message to see if it should be decrypted.
 * @param message the incoming message.
 * @param buddy the buddy that is sending the message.
 * @param isAuto if this message has been automaticly sent to us.
 */
void Rot13::inChatMessage( QString message, QString buddy, bool isAuto  ){
  if( message.length() > 6){
    if( message.left(6) == "rot13("){
      //qDebug("Decrypting a message");
      message = message.mid(6,message.length()-7);
      message = decrypt(message);
    }
  }
  emit ( goingInChatMessage( message, buddy, isAuto ) );
}

/**
 * Checks the message to see if it should be encrypted depending on if the button is down.
 * @param message the outgoing message.
 * @param buddy the buddy that is being sent the message.
 * @param isAuto if this message has been automaticly sent.
 */
void Rot13::outChatMessage( QString message, QString buddy, bool isAuto, bool endIdleNess  ){
  Chat *window = windows.first();
  QToolButton *b = NULL;
  // Find the chatWindow.
  while(window != NULL){
    if( window->getContactName() == buddy){
      int r = windows.find(window);
      if( r == -1 ) qDebug("Can't find window");
      b = buttons.at(r);
      break;
    }
    window = windows.next();
  }
  if( b != NULL && b->isOn() == true ){
    //qDebug("Encrypting a message.");
    message = QString("rot13(") + encrypt(message) + ")";
  }
  emit ( goingOutChatMessage( message, buddy, isAuto, endIdleNess ) );
}

/**
 * Decrypts a message based upon roundNumber. 
 * @param cryptedMessage the message to decrypt.
 * @return The decrypted message.
 */
QString Rot13::decrypt( const QString &cryptedMessage ){
  QString crypted;
  int len = cryptedMessage.length();
  for (int i = 0; i < len; i ++){
    int temp = cryptedMessage[i].latin1();
    //qDebug("'%c' becomes ", temp);
    if( temp > 64 && temp < 91 ){
      // A capital letter 
      temp -= roundNumber;
      if(temp < 65)
        temp = temp + 26;
    }
    
    if( temp > 96 && temp < 123 ){
      // A lower case letter 
      temp -= roundNumber;
      if(temp < 97)
        temp = temp + 26;
    } 

    else if ( (temp >= '0') && (temp <= '4') )//temp is a number
      temp += 5;
    else if ( (temp >= '5') && (temp <= '9') )
      temp -= 5;

    //qDebug(" '%c'\n", temp);
    crypted += (char)temp;
  }
  return crypted;
}

/**
 * Encrypts a message based upon roundNumber. 
 * @param plainMessage the message to encrypt.
 * @return The encrypted message.
 */
QString Rot13::encrypt( const QString &plainMessage ){
  QString crypted;
  int len = plainMessage.length();
  for (int i = 0; i < len; i ++){
    int temp = plainMessage[i].latin1();
    //qDebug("'%c' becomes ", temp);
    if( temp > 64 && temp < 91 ){
      // A capital letter 
      temp += roundNumber;
      if(temp > 90)
        temp = temp - 26;
    }
    
    if( temp > 96 && temp < 123 ){
      // A lower case letter 
      temp += roundNumber;
      if(temp > 122)
        temp = temp - 26;
    } 

    else if ( (temp >= '0') && (temp <= '4') )//temp is a number
      temp += 5;
    else if ( (temp >= '5') && (temp <= '9') )
      temp -= 5;

    //qDebug(" '%c'\n", temp);
    crypted += (char)temp;
  }
  return crypted;
}

/**
 * Save the round number in the settings.
 */
void Rot13::saveSettings(){
  QString DirStr = QDir::homeDirPath() + "/.kinkatta/plugins/rot13.settings" ;
  QFile::remove(DirStr);
  Preferences prefs(DirStr, info.Name, info.Version);
  prefs.setNumber("rot13Number", roundNumber);
  prefs.flush();
}

// rot13.cpp

