/***************************************************************************
                           releasenotification.cpp 
                           -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "releasenotification.h"
#include "configure.h"
#include <qpushbutton.h>
#include <kapp.h>
#include <ktempfile.h>
#include <kio/netaccess.h>
#include <qmessagebox.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include "preferences.h"
#include <qdir.h>

extern "C"
{
  void* create_plugin()
  {
    return new ReleaseNotification;
  }
};

/**
 * Constructor.  Initializes the plugin info and settings.
 * @param parent the parent widget
 * @param name the name of this widget
 */
ReleaseNotification::ReleaseNotification(QWidget *parent, const char *name) : KinkattaPlugin( parent,name ){
  info.Name = "Release Notification";
  info.Author = "Benjamin Meyer";
  info.Version = "1.00";
  info.HomePage = "http://kinkatta.sourceforge.net/";

  configureWidget = NULL;
  IgnoreThisUpdate = "0.00";
  checkForUpdateReportErrors = true;
}

/**
 * Reads in the settings.
 */
void ReleaseNotification::initPlugin(){
  // Read Settings.
  QString DirStr = QDir::homeDirPath() + "/.kinkatta/plugins/releasenotification.settings" ;
  Preferences prefs(DirStr, info.Name, info.Version);

  prefs.setGroup("Settings");
  IgnoreThisUpdate = prefs.getString("IgnoreThisUpdate", IgnoreThisUpdate);

  checkForUpdateReportErrors = false;
  IgnoreThisUpdate = kinkattaVersionNumber;
  checkForUpdates();
}
 
/**
 * Creates the configure widget if there isn't one.
 * @param parent the parent widget for the configure widget if one needs to be made.
 * @return QWidget the configure widget for this plugin.
 */
QWidget *ReleaseNotification::configure( QWidget *parent ){
  if ( configureWidget == NULL ){
    configureWidget = new Configure(parent, "Release Notification Configure window.");
    connect( configureWidget->checkNow, SIGNAL(clicked()), this, SLOT(checkForUpdatesWError()));
  }
  return configureWidget;
}	

/**
 * Check with the website to see if there are any updates.	State no
 * if there is none.
 */
void ReleaseNotification::checkForUpdatesWError(){
  checkForUpdateReportErrors = true;
  checkForUpdates();
}

/**
 *
 */
void ReleaseNotification::checkForUpdates(){
  KTempFile tempFile(QString("kinkatta-update"));
  QFileInfo fi( *tempFile.file() );
  //qDebug("data %s t \n%s\n", data.latin1(), fi.absFilePath().latin1());
  
  QString u = "http://kinkatta.sourceforge.net/update/current_version";
  KURL source(u);
  KURL dest(fi.absFilePath());

  KApplication::setOverrideCursor(Qt::waitCursor);
  KIO::FileCopyJob *copyJob = new KIO::FileCopyJob(source, dest, 600, FALSE, TRUE, FALSE, FALSE);
  connect(copyJob, SIGNAL(result(KIO::Job*)), this, SLOT(checkForUpdatesResult(KIO::Job*)));
}

/**
 * Check with the website to see if there are any updates.
 */
void ReleaseNotification::checkForUpdatesResult(KIO::Job *job){
  KIO::FileCopyJob *copyJob = dynamic_cast<KIO::FileCopyJob*> (job);

  QString newVersion;
  if ( copyJob->error() != 0 ){
    qApp->restoreOverrideCursor();
    QMessageBox::information(0, "Kinkatta - Error",("Unable to retrieve version info."), QMessageBox::Ok);
    return;
  }

  //KApplication::setOverrideCursor(Qt::waitCursor);
    
  KURL localFile = copyJob->destURL();
  QFile file( localFile.path() );
  newVersion = kinkattaVersionNumber;
  if (file.open(IO_ReadWrite)){
    newVersion = "";
    QTextStream stream(&file);
    while(!stream.eof()){
      newVersion += stream.readLine();
    }
    file.close();
    file.remove();
  } else {
    file.remove();
    qApp->restoreOverrideCursor();
    QMessageBox::information(0, "Kinkatta - Error",("Could not retrieve latest version\n"
      "information.	The website might be down."), QMessageBox::Ok);
    return;
  }

  // timeouts etc.
  if (newVersion.length() == 0) {
    qApp->restoreOverrideCursor();
    QMessageBox::information(0, "Kinkatta - Error",("Could not retrieve latest version\n"
      "information.	The website might be down."), QMessageBox::Ok);
    return;
  }

  bool isNewVersion = false;
  isNewVersion = newVersion != (QString("Version ") + kinkattaVersionNumber);
  if (isNewVersion){
    if ((checkForUpdateReportErrors == true) || newVersion != IgnoreThisUpdate) {
      KTempFile tempFile(QString("kinkatta-changes"));
      QFileInfo fi( *tempFile.file() );
      //qDebug("data %s t \n%s\n", data.latin1(), fi.absFilePath().latin1());

      QString u = "http://kinkatta.sourceforge.net/update/latest_changes";
      KURL source(u);
      KURL dest(fi.absFilePath());

      KApplication::setOverrideCursor(Qt::waitCursor);
      KIO::FileCopyJob *copyJob = new KIO::FileCopyJob(source, dest, 600, FALSE, TRUE, FALSE, FALSE);
      connect(copyJob, SIGNAL(result(KIO::Job*)), this, SLOT(checkForChangesResult(KIO::Job*)));
    }
    else {
      qApp->restoreOverrideCursor();
      if (checkForUpdateReportErrors == true)
        QMessageBox::information(0, "Kinkatta - Results","There are no new versions\n of Kinkatta at this time", "OK");
      checkForUpdateReportErrors = false;
    }
  }
  else {
    qApp->restoreOverrideCursor();
    if (checkForUpdateReportErrors == true)
      QMessageBox::information(0, "Kinkatta - Results","There are no new versions\n of Kinkatta at this time", "OK");
    checkForUpdateReportErrors = false;
  }
	  
  qApp->restoreOverrideCursor();
}

/**
 *
 */
void ReleaseNotification::checkForChangesResult(KIO::Job *job){
  KIO::FileCopyJob *copyJob = dynamic_cast<KIO::FileCopyJob*> (job);
  QString newVersion;
	
  if ( copyJob->error() != 0 ){
    qApp->restoreOverrideCursor();
    return;
  }

  //KApplication::setOverrideCursor(Qt::waitCursor);
  KURL localFile = copyJob->destURL();
  QFile file( localFile.path() );
  QString newChanges = "";
  if (file.open(IO_ReadWrite)) {
    QTextStream stream(&file);
    while(!stream.eof()) {
      newChanges += stream.readLine();
      newChanges += "\n";
    }
    file.close();
    file.remove();
  }
  else {
    qApp->restoreOverrideCursor();
    file.remove();
    QMessageBox::information(0, "Kinkatta - Error",("Could not retrieve latest version changes\nThe website might be down."), QMessageBox::Ok);
    return;
  }
  
  newChanges = QString("A newer version of Kinkatta has been released.\n\n") + newChanges;
  int choice = -1;
  qApp->restoreOverrideCursor();
  choice = QMessageBox::information(0, QString("New Kinkatta Release") + newVersion,newChanges, "OK","Open Web Site","Don't show this version again.");
  if (choice == 1){
    KApplication::kApplication()->invokeBrowser( "http://kinkatta.sourceforge.net/" );
  }
  if (choice == 2){
    IgnoreThisUpdate = newVersion;
    QString DirStr = QDir::homeDirPath() + "/.kinkatta/plugins/releasenotification.settings" ;
    Preferences prefs(DirStr, info.Name, info.Version);
    prefs.setGroup("Settings");
    prefs.setString("IgnoreThisUpdate", IgnoreThisUpdate);
  }
}

// releasenotification.cpp

