/***************************************************************************
                              pluginsimp.cpp
                             -------------------
    begin                : Tuesday Nov 4 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "pluginpriorityimp.h"
#include <qpushbutton.h>
#include <qlistbox.h>
#include "kinkattaplugin.h"

/**
 * Constructor.  Connects the buttons the the right slots.
 * @param parent the parent widget
 * @param name the name of this widget
 */
PluginPriorityImp::PluginPriorityImp(QWidget *parent, const char *name) : PluginPriority( parent,name ){
  connect(buttonMoveUp, SIGNAL(clicked()), this, SLOT(upClicked()));
  connect(buttonMoveDown, SIGNAL(clicked()), this, SLOT(downClicked()));
  connect(buttonOk, SIGNAL(clicked()), this, SLOT(okClicked()));
}

/**
 * Does nothing.
 */
PluginPriorityImp::~PluginPriorityImp(){
}

/**
 * Sets up the internal list of plugins.
 * @param tplugins the list of plugins to use.
 */
void PluginPriorityImp::setPlugins(QList<KinkattaPlugin> &tplugins){
  plugins = tplugins;
  loadList();
}

/**
 * emit the new list of plugins.
 */
void PluginPriorityImp::okClicked(){
  emit (  setPluginList(plugins) );
}

/**
 * Load the plugins into the widget.
 */
void PluginPriorityImp::loadList(){
  pluginList->clear();
  KinkattaPlugin *plugin = plugins.first();
  while(plugin != NULL){
    int at = plugins.at();
    pluginList->insertItem(plugin->getName(), at);
    plugin = plugins.next();
  }
  if (pluginList->count() > 0 )
    pluginList->setCurrentItem(pluginList->topItem());
}

/**
 * Move the current plugin up in the list.
 */
void PluginPriorityImp::upClicked(){
  if( pluginList->count() <= 1 )
    return;
  if( pluginList->currentItem() == -1 )
    return;
   
  QString name = pluginList->currentText();
  KinkattaPlugin *plugin = plugins.first();
  while(plugin != NULL){
    if( plugin->getName() == name )
      break;
    plugin = plugins.next();
  }
  if( plugin == NULL ) return;
    
  int place = plugins.at();
  //qDebug( "Moving Up");
  
  if( place == 0 )
    return;
 
  plugins.remove( plugin );
  plugins.insert( place, plugin );
  pluginList->removeItem( place );
  pluginList->insertItem( plugin->getName(), place );

  if (pluginList->count() > 0 )
    pluginList->setCurrentItem(pluginList->topItem());
}

/**
 * Move the current plugin down in the list.
 */
void PluginPriorityImp::downClicked(){
  if( pluginList->count() <= 1 )
    return;
  if( pluginList->currentItem() == -1 )
    return;

  QString name = pluginList->currentText();  
  KinkattaPlugin *plugin = plugins.first();
  while(plugin != NULL){
    if( plugin->getName() == name )
      break;
    plugin = plugins.next();
  }
  if( plugin == NULL ) return;
    
  int place = plugins.at();
  //qDebug( "Moving Down");
  int total = (pluginList->count()-1);
  if( place == total )
    return;
 
  plugins.remove( plugin );
  plugins.insert( place+1, plugin );
  pluginList->removeItem( place );
  pluginList->insertItem( plugin->getName(), place+1 );

  if (pluginList->count() > 0 )
    pluginList->setCurrentItem(pluginList->topItem());
}

// PluginPriorityImp.cpp

