/***************************************************************************
                           plugincombobox.cpp 
                           -------------------
    begin                : Saturday Dec 1 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "plugincombobox.h"

/**
 * Constructor.  Connects up the activated signal to our signal. 
 * @param parent the parent widget
 * @param name the name of the widget
 */
KinkattaComboBox::KinkattaComboBox(QWidget *parent=0, const char *name=0) : QComboBox(parent, name){
  connect(this, SIGNAL(activated(const QString &)), this, SLOT(choiceChanged(const QString &)));
}

/**
 * Does nothing.
 */
KinkattaComboBox::~KinkattaComboBox(){
}

/**
 * Emit a signal showing that the item has been selected.
 * @Param choice the item that has been selected in the combo box.
 */
void KinkattaComboBox::choiceChanged( const QString &choice ){
  emit ( changed(choice, buddy) );
}

// plugincombobox.cpp

