/***************************************************************************
                          kinkattachatplugin.cpp 
                           -------------------
    begin                : Saturday Dec 1 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "kinkattachatplugin.h"
#include "chat.h"
#include "buddylistwindow.h"
#include <qtoolbar.h>

/**
 * Constructor.  Initializes the plugin info and settings.
 * @param parent the parent widget
 * @param name the name of this widget
 */
KinkattaChatPlugin::KinkattaChatPlugin(QWidget *parent, const char *name) : KinkattaPlugin( parent,name ){
  info.messagePlugin = true;
}

/**
 * Does Nothing.
 */
KinkattaChatPlugin::~KinkattaChatPlugin(){
}

/**
 * Connects the window creation distroying pointers.
 */
void KinkattaChatPlugin::initPlugin(){
  connect(mainWindow, SIGNAL(creatingChatWindow(Chat*)), this, SLOT(chatWindowCreated(Chat*)));
  connect(mainWindow, SIGNAL(distroyingChatWindow(Chat*)), this, SLOT(distroyingChatWindow(Chat*)));
}

/**
 * When a window is destroyed we are told about it.
 * @param window the window to remove from the list.
 */ 
void KinkattaChatPlugin::distroyingChatWindow( Chat*window ){
  //qDebug("Distroying a chat link");
  int find = windows.find(window);
  if( find != -1){
    windows.remove(find);
    buttons.remove(find);
  }
}

/**
 * When a window is created we are told about it.
 * @param window the window to add to the list.
 */
void KinkattaChatPlugin::chatWindowCreated( Chat*window ){
  //qDebug("We have a chat window");
  QToolBar *theToolBar = window->getPluginToolbar();
  theToolBar->show();
  QToolButton *b = new QToolButton(theToolBar, (info.Name).latin1());
  b->setPixmap(image);
  b->setToggleButton(true);
  buttons.append(b);
  windows.append(window);
}

/**
 * Creates a button in the chat window that has some set text in it.
 * @param window the window to put the button in.
 * @param text the text to use for the button.
 */
void KinkattaChatPlugin::makeToolButton( Chat*window, QString text ){
  QToolBar *theToolBar = window->getPluginToolbar();
  theToolBar->show();
  QToolButton *b = new QToolButton(theToolBar, text.latin1());
  b->setToggleButton(true);

  //QPixmap image(16,16);
  //int id = theToolBar->insertButton(image, -1,true, text,-1);
  //KToolBarButton *button = theToolBar->getButton(id);
  // make up and down;
}

// kinkattachatplugin.cpp

