/***************************************************************************
                              babelfishplugin.h
                             -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef KINKATTAPLUGINBABELPLUGIN_H
#define KINKATTAPLUGINBABELPLUGIN_H

#include <kinkattacomboplugin.h>

class Configure;
class Babel;


/**
 * The Babelfish plugin can translate messages on the fly for people.  For
 * a list of the languages supported see setType in the Babel class.  This
 * plugin is a message plugin and thus does watch messages as they pass
 * through the system translating them as need be.  
 * @author Benjamin Meyer
 */

class BabelPlugin : public KinkattaComboPlugin {

Q_OBJECT
	
signals:

public:
  /// Constructor.
  BabelPlugin(QWidget *parent=0, const char *name=0);
  
  /// Deconstructor.
  virtual ~BabelPlugin();

public slots:
  /// Requests the the configure widget for this plugin.
  virtual QWidget *configure( QWidget *parent );	

  /// Get the settings from the configure widget and apply them.
  virtual void applyConfigure();
  
  /// A message has come from the network for this plugin to handle.
  virtual void inChatMessage( QString buddy, QString message, bool isAuto );

  /// A message in going out for this plugin to handle.
  virtual void outChatMessage( QString buddy, QString message, bool isAuto, bool endIdleNess );

  /// After this plugin has been initialized this function is called.
  virtual void initPlugin();

private slots:

  /// A message that is translated goes into the system.
  void messageTranslatedIn( QString message, QString buddy );

  /// A message that is translated goes out of the system.
  void messageTranslatedOut( QString message, QString buddy );

protected:
  /// This plugins configure widget.
  Configure *configureWidget;

  /// The socket used to translate the message
  Babel *socket;

};

#endif

// babelplugin.h

