/***************************************************************************
                              awayschedule.h
                             -------------------
    begin                : Saturday Dec 1 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef APPOINTMENTPLUGIN_H
#define APPOINTMENTPLUGIN_H

#include <kinkattaplugin.h>
#include <qlist.h>
#include <qtoolbutton.h>
#include "appointmentimp.h"

class ChatWindow;
class Configure;

/**
 * The Away Schedule plugin allows you to set up a schedule for your week that
 * it will use to automatically set the you away during those times with
 * specified messages.  
 * @author Benjamin Meyer
 */
class AwaySchedule : public KinkattaPlugin {

Q_OBJECT
	
signals:

public:
  /// Constructors
  AwaySchedule(QWidget *parent=0, const char *name=0);
  /// Deconstructors
  virtual ~AwaySchedule();

public slots:
  /// Requests the the configure widget for this plugin.
  virtual QWidget *configure( QWidget *parent );	

  /// Get the settings from the configure widget and apply them.
  virtual void applyConfigure();
  
  /// After this plugin has been initialized this function is called.
  virtual void initPlugin();

  /// When it is time to save settings this function is called.
  void saveSettings();

private slots:

  /// Create a new appointment.
  void addAppointment();

  /// Remove an appointment.
  void removeAppointment();

  /// Edit a appointment that is already there.
  void editAppointment();

  /// An appointment was add/edit and needs to be possibly removed.
  void cancelAppointment( appointment *a );

  /// An appointment was add/edit and needs to be updated.
  void updateAppointment( appointment *a );

  /// A new day was selected, update the configure widget.
  void updateDay( int );

  /// Check to see if there is an appointment right now that we should go away to.
  void checkToSeeIfWeShouldGoAway();
 
private:
  // Helper function to find the current appointment that is selected in the struct.
  appointment *findCurrentAppointment();

protected:
  /// This plugins configure widget.
  Configure *configureWidget;
  
  /// When set to true the plugin will control the away stuff.
  bool enabled; 

  /// The list of appointments.
  QList<appointment> appointments;

};

#endif

// awayschedule.h

