/***************************************************************************
                            appointmentimp.cpp 
                           -------------------
    begin                : Saturday Dec 1 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "appointmentimp.h"
#include <qstring.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qmultilineedit.h>

/**
 * Constructor.  Initializes connections and settings.
 * @param parent the parent widget
 * @param name the name of this widget
 */
AppointmentImp::AppointmentImp(QWidget *parent, const char *name) : Appointment(parent, name){
  connect(buttonCancel, SIGNAL(clicked()), this, SLOT(cancelClicked()));
  connect(buttonOk, SIGNAL(clicked()), this, SLOT(okClicked()));
  a = NULL;
}

/**
 * Does nothing.
 */
AppointmentImp::~AppointmentImp(){
}

/**
 * Close this widget.  emit cancelAppointment.
 */
void AppointmentImp::cancelClicked(){
  emit( cancelAppointment( a ) );
  this->close(1);
}

/**
 * Set this to an appointment.
 * @param newA the appointment to set current too.
 */
void AppointmentImp::setAppointment( appointment *newA ){
  a = newA; 
  startHour->setValue( a->startHour );
  startMinute->setValue( a->startMinute );
  endHour->setValue( a->endHour );
  endMinute->setValue( a->endMinute );
  message->setText( a->message );
} 

/**
 * emit Update for the appointment and close.
 */
void AppointmentImp::okClicked(){
  if( a == NULL ){
    qDebug("Appointment has not been set.  Please report this bug.");
    return;
  }  
  
  a->startHour = startHour->value();
  a->startMinute = startMinute->value();
  a->endHour = endHour->value();
  a->endMinute = endMinute->value();
  a->message = message->text();
  emit( updateAppointment( a ) );
  this->close(1);
}

// appointment.cpp

