/***************************************************************************
                           mainwindowoptionsimp.cpp
                             -------------------
    begin                : Tuesday Jan 10 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "mainwindowoptionsimp.h"
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qfont.h>
#include <kfontdialog.h>
#include <qapplication.h>
#include <qcombobox.h>
#include <qpushbutton.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
MainWindowOptionsImp::MainWindowOptionsImp(QWidget *parent, const char *name) : MainWindowOptions ( parent,name,false ){
	i_aimSettings = setup::settings();
  resizeWidth->setChecked(true);
  resizeWidth->setChecked(false);
  resizeHeight->setChecked(true);
  resizeHeight->setChecked(false);
connect(buddylistOnlineFont_change, SIGNAL(clicked()), this, SLOT(changebuddylistOnlineFont()));
  connect(buddylistOnlineFont_default, SIGNAL(clicked()), this, SLOT(setDefaultbuddylistOnlineFont()));
  connect(buddylistOfflineFont_change, SIGNAL(clicked()), this, SLOT(changebuddylistOfflineFont()));
  connect(buddylistOfflineFont_default, SIGNAL(clicked()), this, SLOT(setDefaultbuddylistOfflineFont()));
  connect(buddylistSignOnFont_change, SIGNAL(clicked()), this, SLOT(changebuddylistSignOnFont()));
  connect(buddylistSignOnFont_default, SIGNAL(clicked()), this, SLOT(setDefaultbuddylistSignOnFont()));

}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
MainWindowOptionsImp::~MainWindowOptionsImp(){
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void MainWindowOptionsImp::updateData(){
  i_aimSettings = setup::settings();

  resizeHeight->setChecked(true);
  resizeWidth->setChecked(true);
  loginMoveRight->setChecked(true);

  resizeHeight->setChecked(i_aimSettings->main_resizeHeight);
  resizeHeightMax->setValue(i_aimSettings->main_resizeHeightMax);
  resizeWidth->setChecked(i_aimSettings->main_resizeWidth);
  resizeWidthMax->setValue(i_aimSettings->main_resizeWidthMax);
  if (i_aimSettings->main_loginMoveRight == true)
    loginMoveRight->setChecked(true);
  if (i_aimSettings->main_loginMoveLeft == true)
    loginMoveLeft->setChecked(true);
  if (i_aimSettings->main_loginMoveNo == true)
    loginMoveNo->setChecked(true);
  showIdle->setChecked(i_aimSettings->main_showIdle);
  showLastOn->setChecked(i_aimSettings->main_showLastOn);
  noButtons->setChecked(i_aimSettings->main_noIcons);
  loginMoveDown->setValue(i_aimSettings->main_moveDown);
  
	if (i_aimSettings->main_idleLayout == 1)
		loginIdleLayout1->setChecked(true);
  else
	  loginIdleLayout2->setChecked(true);

  noHeaders->setChecked(i_aimSettings->main_noHeader);
  x11IdleTime->setChecked(i_aimSettings->main_useX11ForIdle);
  showTrayTooltip->setChecked(i_aimSettings->main_showTraySignonTooltip);
  main_noSoundOnLogin->setChecked(i_aimSettings->main_mute_on_login);

  updateLabel(TextLabel_buddylistOnlineFont, i_aimSettings->buddylistFontSettings->buddylist_OnlineFont);

  updateLabel(TextLabel_buddylistOfflineFont, i_aimSettings->buddylistFontSettings->buddylist_OfflineFont);

  updateLabel(TextLabel_buddylistSignOnFont, i_aimSettings->buddylistFontSettings->buddylist_SignOnFont);

}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void MainWindowOptionsImp::getData(){
  i_aimSettings->main_resizeHeight = resizeHeight->isChecked();
  i_aimSettings->main_resizeHeightMax = resizeHeightMax->text().toInt();
  i_aimSettings->main_resizeWidth = resizeWidth->isChecked();
  i_aimSettings->main_resizeWidthMax = resizeWidthMax->text().toInt();
  if (loginMoveRight->isChecked() == true)
    i_aimSettings->main_loginMoveRight = true;
  else
    i_aimSettings->main_loginMoveRight = false;
  if (loginMoveLeft->isChecked() == true)
    i_aimSettings->main_loginMoveLeft = true;
  else
    i_aimSettings->main_loginMoveLeft = false;
  if (loginMoveNo->isChecked() == true)
    i_aimSettings->main_loginMoveNo = true;
  else
    i_aimSettings->main_loginMoveNo = false;

  i_aimSettings->main_showIdle = showIdle->isChecked();
  i_aimSettings->main_showLastOn = showLastOn->isChecked();
  i_aimSettings->main_noIcons = noButtons->isChecked();
  i_aimSettings->main_moveDown = loginMoveDown->text().toInt();
  
	if (loginIdleLayout1->isChecked() == true)
	  i_aimSettings->main_idleLayout = 1;
	else
		i_aimSettings->main_idleLayout = 2;
  
  i_aimSettings->main_noHeader = noHeaders->isChecked();
  i_aimSettings->main_showTraySignonTooltip = showTrayTooltip->isChecked();
  i_aimSettings->main_useX11ForIdle = x11IdleTime->isChecked();
  i_aimSettings->main_mute_on_login = main_noSoundOnLogin->isChecked();

}


/**
 * Helper function.  Sets a button to have a font 'f'
 * @param l label to fill.
 * @param f font to user.
 */
void MainWindowOptionsImp::updateLabel( QLabel *l, const QFont &f ){
  l->setFont( f );
  l->setText( f.family() + " " + QString::number(f.pointSize()) + "pt");
}

/**
 * Font Dialog function
 */
void MainWindowOptionsImp::updateFontSetting(QFont &f, QLabel *l){
  if( KFontDialog::getFont(f, false, this) )
    updateLabel(l, f);
}

/**
 * Bring up the dialog to change the buddylist Online font.
 */
void MainWindowOptionsImp::changebuddylistOnlineFont(){
  updateFontSetting(i_aimSettings->buddylistFontSettings->buddylist_OnlineFont, 
    TextLabel_buddylistOnlineFont);
}

/**
 * Bring up the dialog to change the buddylist Offline font.
 */
void MainWindowOptionsImp::changebuddylistOfflineFont(){
	updateFontSetting(i_aimSettings->buddylistFontSettings->buddylist_OfflineFont, 
  TextLabel_buddylistOfflineFont);
}

/**
 * Bring up the dialog to change the buddylist Signon font.
 */
void MainWindowOptionsImp::changebuddylistSignOnFont(){
  updateFontSetting(i_aimSettings->buddylistFontSettings->buddylist_SignOnFont, 
  TextLabel_buddylistSignOnFont);
}

/**
 * Set the default buddy list Online Font
 */
void MainWindowOptionsImp::setDefaultbuddylistOnlineFont(){
  QFont tempFont;
  tempFont = i_aimSettings->buddylistFontSettings->buddylist_OnlineFont = qApp->font();
  updateLabel(TextLabel_buddylistOnlineFont, tempFont);
}

/**
 * Set the default buddy list Offline Font.
 */
void MainWindowOptionsImp::setDefaultbuddylistOfflineFont(){
  QFont tempFont;
  tempFont = qApp->font();
  tempFont.setItalic( TRUE );
  i_aimSettings->buddylistFontSettings->buddylist_OfflineFont = tempFont;
  updateLabel(TextLabel_buddylistOfflineFont, tempFont);
}

/**
 * Set the default buddy list SignOn Font.
 */
void MainWindowOptionsImp::setDefaultbuddylistSignOnFont(){
  QFont tempFont;
  tempFont = qApp->font();
  tempFont.setWeight( QFont::Bold );
  i_aimSettings->buddylistFontSettings->buddylist_SignOnFont = tempFont;
  updateLabel(TextLabel_buddylistSignOnFont, tempFont);
}

// MainWindowOptionsImp.cpp

