// tsfbuffer.cpp
//
// Kit AIM client
//
// For copyright and license, see accompanying documentation

#include "config.h"

extern "C"
{
#include <pthread.h>
}

#include <qglobal.h>
#include "tsfbuffer.h"

// *******************
// * class TSFBuffer *
// *******************
TSFBuffer::TSFBuffer()
{
	head = 0;
	tail = 0;
	receivedFrame = false;
	pthread_mutex_init(&mutex, 0);
}
TSFBuffer::~TSFBuffer()
{
	pthread_mutex_destroy(&mutex);
}
void TSFBuffer::clear()
{
	pthread_mutex_lock(&mutex);

	while(head != 0)
	{
		sfb_entry *temp = head;
		head = head->next;
		if(head != 0) head->prev = 0;
		delete temp;
	}
	pthread_mutex_unlock(&mutex);
	receivedFrame = false;
}
void TSFBuffer::writeFrame(sflap_frame &frame)
{
	pthread_mutex_lock(&mutex);
	sfb_entry *cur;
	sfb_entry *temp = new sfb_entry;
	temp->frame = frame;
	if(!receivedFrame)
	{
		receivedFrame = true;
		firstInSequence = frame.sequence;
	}
	if(head == 0)
	{
		// first entry
		temp->next = 0;
		temp->prev = 0;
		head = temp;
		tail = head;
		pthread_mutex_unlock(&mutex);
		return;
	}
	// this is complicated, to handle wraparound
	if(
	   (tail->frame.sequence < frame.sequence) ||
	   ( (tail->frame.sequence > firstInSequence) && (frame.sequence <= firstInSequence) )
	  )
	{
		// new tail
		temp->prev = tail;
		temp->next = 0;
		tail->next = temp;
		tail = temp;
		pthread_mutex_unlock(&mutex);
		return;
	}
	cur = tail->prev;
	while( (cur != 0) && (cur->frame.sequence > frame.sequence) )
		cur = cur->prev;

	if(cur == 0)
	{
		// new head
		temp->prev = 0;
		temp->next = head;
		head->prev = temp;
		head = temp;
		pthread_mutex_unlock(&mutex);
		return;
	}
	// somewhere in the middle
	temp->prev = cur;
	temp->next = cur->next;
	cur->next = temp;
	temp->next->prev = temp;
	pthread_mutex_unlock(&mutex);

}
int TSFBuffer::readFrame(sflap_frame &frame)
{
	if(!head) return -1;
	pthread_mutex_lock(&mutex);
	frame = head->frame;
	sfb_entry *temp = head;
	head = head->next;
	if(head != 0) head->prev = 0;
	delete temp;
	pthread_mutex_unlock(&mutex);
	return 0;
}
