/***************************************************************************
                                awaymessage.h
                             -------------------
    begin                : Sun Feb 20 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef AWAYMESSAGE_H
#define AWAYMESSAGE_H

#include <qwidget.h>
#include <qmultilinedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>

#include <setup.h>

/**
 * Away message widget.
 * A widget that attaches to the bottom of the main window.  Tells the
 * user that there they are currently set to away and to click on the
 * back button to be back.  While this window is open auto response
 * messages are sent.
 * @author Benjamin Meyer
 */
class AwayMessage : public QWidget {
  Q_OBJECT

  signals:
  
  /// Emitted when the Back button is pressed
  void backClicked();
  
  /// Emitted when the Update button is pressed
  void update(QString);	
      
  public:

  /// Constructor
  AwayMessage(QWidget *parent=0, const char *name=0);


  /// Destructor
  ~AwayMessage();

  /// Set the away message
  void setText(QString text);

  /// Resize event handler
  void resizeEvent ( QResizeEvent *e );

  /// Creates the dialog GUI.
  void initDialog();

    //Generated area. DO NOT EDIT!!!(begin)
    QMultiLineEdit *message;
    QPushButton *Back;
		QPushButton *Update;
    QLabel *text1;
    QLabel *text2;
    QCheckBox *no_sound;
    //Generated area. DO NOT EDIT!!!(end)

  private:
    /// Saved sound setting
    int oldSoundSettings;

    /// The settings data
    settings_t *i_aimSettings;
	
  private slots:

    /// Called to change the away sound mode
    void toggle(bool on);
  
  /// Called when the Back button is pressed
    void back();

    /// Called when the Update button is pressed
    void updateClicked();

    /// Called when the away message is changed
    void textChanged();

};

#endif

// awaymessage.h

