/***************************************************************************
		                   kinkattadock.cpp 
	                       -------------------
		begin                : May 10 2001
		copyright            : (C) 2001 by Dimi Shahbaz
		email                : dshahbaz@ucla.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtooltip.h>
#include <qdir.h>
#include <qpoint.h>
#include <kwin.h>
#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <kapp.h>
#include <qlabel.h>
#include <qtimer.h>

//These delays are in seconds!!

/// Seconds to delay changing the buddy icon after signing on
#define POST_BUDDY_SIGNON_DELAY 10

/// Seconds to delay changing the buddy icon after signing off
#define POST_BUDDY_SIGNOFF_DELAY 10

/// Seconds to delay playing sounds after signing on
#define POPUP_ENABLE_LOGIN_TIME 20

#include "kinkattadock.h"
#include "taim.h"

/**
 * Display the dock if it is enabled.  Load the pixmaps for the dock.
 * Configure the pop-up menu.
 */

DockWidget::DockWidget(QWidget *parent, const char *name)
	: /*KDockWindow */ KSystemTray(parent, name){

	awayMenu = NULL;
	awayMenuID = -1;

	//To check if the popup is enabled in the settings
	i_aimSettings = setup::settings();

	kinkattaVisible = TRUE;
	allVisible = TRUE;
	delaySignonPopup = FALSE;

	connectionState = TAIM_OFFLINE;

	// load pixmaps
	dock_online_pixmap = SmallIcon("dock_online");
	dock_offline_pixmap = SmallIcon("dock_offline");
	dock_away_pixmap = SmallIcon("dock_away");
	signonIcon = SmallIcon("connect_established");
	signoffIcon = SmallIcon("connect_no");
	//show();

	// popup menu for right mouse button
	popup_m = new KPopupMenu();
	popup_m->insertTitle(i18n("Kinkatta"));
	showKinkattaID = popup_m->insertItem(i18n("&Show"),
				 this, SLOT(showKinkattaClicked()));
	/*
	showAllKinkattaID = popup_m->insertItem(i18n("Show &All"),
				 this, SLOT(showAllClicked()));
	*/
	popup_m->insertSeparator();
	popup_m->insertItem(SmallIcon("configure"), i18n("&Preferences..."), this, SIGNAL(showKinkattaConfig()));
	popup_m->insertItem(SmallIcon("configure"), i18n("P&lugins..."), this, SIGNAL(showKinkattaPlugins())); 
	popup_m->insertItem(SmallIcon("exit"), i18n("E&xit"), this, SIGNAL(exitKinkatta()));
	signonID = popup_m->insertItem(signonIcon, i18n("Sign&on"), this, SLOT(signOnClicked()));


	toolTip = new QLabel(this, "toolTip");
	toolTip->setGeometry( QRect( 10, 10, 40, 50 ) );
	QPoint p = toolTip->mapToGlobal( QPoint( x() - 30, y() - 30) );
	toolTip->move( p );

	dockPopup = new DockPopup();
	connect(dockPopup, SIGNAL(anchorMoved()), this, SLOT(popupAnchorMoved()));
	/* If this is the first appearance of the dockWidget, guess a good location
	 * for the popup to appear.  Since it is moveable, it's location will be
	 * stored every time it is moved.
	 */
	if( i_aimSettings->main_traySignonTooltipPosX
			&&	i_aimSettings->main_traySignonTooltipPosY ){
		QPoint anchor( i_aimSettings->main_traySignonTooltipPosX, 
					i_aimSettings->main_traySignonTooltipPosY );
		dockPopup->setAnchor( anchor,
					(DockPopup::Position) i_aimSettings->main_traySignonTooltipAnchorPosition );
	} else {
		QPoint anchor( KApplication::desktop()->width() - 50, KApplication::desktop()->height() - 50 );
		dockPopup->setAnchor( anchor, DockPopup::BottomRight );
	}
	dockPopup->hide();

	/*
	popupPushItem("<b>TESTING 12 3</b>");
	QTimer::singleShot( 2 * 1000, this, SLOT(popupPopItem()) );
	popupPushItem("<b>Testing hello remo177 stuff</b>");
	QTimer::singleShot( 2 * 1000, this, SLOT(popupPopItem()) );
	popupPushItem("<font color=\"grey\"><i>Testing hello stuff</i></font>");
	QTimer::singleShot( 2 * 1000, this, SLOT(popupPopItem()) );
	*/

}

/**
 * Does nothing remarkable.
 */
DockWidget::~DockWidget() {

}

/**
 * If the user is connected, it will log them off, otherwise it will
 * try to connect.
 */
void DockWidget::signOnClicked(){
	if(connectionState == TAIM_OFFLINE)
		emit tryToConnect();
	else // connectionState == TAIM_ONLINE | TAIM_AWAY
		emit logoff();
}

/**
 * Repaints the icons.
 */
void DockWidget::paintEvent (QPaintEvent *) {
	paintIcon();
}

/**
 * Redraws the icons depending on the connection state.
 */
void DockWidget::paintIcon () {
        this->erase();
	if(connectionState == TAIM_OFFLINE)
		bitBlt(this, 0, 0, &dock_offline_pixmap);
	else if (connectionState == TAIM_ONLINE)
		bitBlt(this, 0, 0, &dock_online_pixmap);
	else if (connectionState == TAIM_AWAY)
		bitBlt(this, 0, 0, &dock_away_pixmap);
}

/**
 * Displays the main window or the popup menu.
 * @param e the mouse event
 */
void DockWidget::mousePressEvent(QMouseEvent *e) {
	// open/close connect-window on right mouse button
	if ( e->button() == LeftButton ) {
		showKinkattaClicked();
	}

	// open popup menu on left mouse button
	if ( e->button() == RightButton ) {
		QString text;

		if(kinkattaVisible)
			text = i18n("&Hide");
		else //!kinkattaVisible
			text = i18n("&Show");
		popup_m->changeItem(showKinkattaID, text);

		/*
		if(allVisible)
			text = i18n("Hide &All");
		else //!allVisible
			text = i18n("Show &All");
		popup_m->changeItem(showAllKinkattaID, text);
		*/

		if( (connectionState == TAIM_ONLINE) || (connectionState == TAIM_AWAY) )
			text = i18n("Signo&ff");
		else //connectionState == TAIM_OFFLINE
			text = i18n("Sign&on");
		popup_m->changeItem(signonID, connectionState == TAIM_OFFLINE ? signonIcon : signoffIcon , text);


		popup_m->popup(e->globalPos());
		popup_m->exec();
	}

}

void DockWidget::signonPopupDelayedEnable(){
	delaySignonPopup = TRUE;
}

/**
 * This is called when the user moves the little tooltip by clicking and
 * dragging it around.  We want to save the position so the next time kinkatta
 * starts, it will put it in the same place.
 */
void DockWidget::popupAnchorMoved(){
	QPoint a = dockPopup->anchor();
	
	i_aimSettings->main_traySignonTooltipPosX = a.x();
	i_aimSettings->main_traySignonTooltipPosY = a.y();
	
	i_aimSettings->main_traySignonTooltipAnchorPosition =
			(int)dockPopup->anchorPosition();

}

/**
 * If the signon tooltips are enabled, push this buddy onto the list
 * to be displayed.
 * @param buddy the buddy who signed off
 */
void DockWidget::buddySignedOff(TBuddy *buddy){
	if(!delaySignonPopup || !i_aimSettings->main_showTraySignonTooltip)
		return;
	
	//TODO: insert <font> tag with the appropriate text color for signoffage
	//maybe in colorgroup.disabledText?
	QString b;
	if(!buddy->alias.isEmpty())
		b = buddy->alias;
	else
		b = buddy->name;

	popupPushItem("<i>" + b + "</i> signed off.");
		
	QTimer::singleShot( POST_BUDDY_SIGNOFF_DELAY * 1000, this, SLOT(popupPopItem()) );

}

/**
 * If the signon tooltips are enabled, push this buddy onto the list
 * to be displayed.
 * @param buddy the buddy who signed off
 */
void DockWidget::buddySignedOn(TBuddy *buddy){
	if(!delaySignonPopup || !i_aimSettings->main_showTraySignonTooltip)
		return;
	
	QString b;
	if(!buddy->alias.isEmpty())
		b = buddy->alias;
	else
		b = buddy->name;
		
	popupPushItem("<b>" + b + "</b> signed on.");

	QTimer::singleShot( POST_BUDDY_SIGNON_DELAY * 1000, this, SLOT(popupPopItem()) );
}

/**
 * Adds a name to the list of names to display
 * @param the buddy name to add
 */
void DockWidget::popupPushItem(QString i){

	//To prevent wordwrapping where we don't want it:
	i = "<nobr>" + i + "</nobr>";

	popupItems.append( i );

	QString s = popupItems.join( "<br>" );
	dockPopup->setText( s );
	dockPopup->show();
	dockPopup->update();

}

void DockWidget::popupPopItem(){
	popupItems.remove(popupItems.begin());
	
	if(popupItems.isEmpty()){
		dockPopup->hide();
		dockPopup->setText( QString::null );
	} else {
		QString s = popupItems.join( "<br>" );
		dockPopup->setText( s );
		dockPopup->show();
		dockPopup->update();
	}
}

/**
 * Appropriately changes the away menu and signon popup states for the
 * new connection state.
 * @param c the new connection state
 */
void DockWidget::connectionChanged(int c){
	connectionState = c;

	switch(connectionState){
		case TAIM_OFFLINE:
			if(awayMenuID != -1)
				popup_m->removeItem(awayMenuID);
			awayMenuID = -1;
			delaySignonPopup = FALSE;
			break;
		case TAIM_ONLINE:
			if(awayMenuID != -1)
				popup_m->removeItem(awayMenuID);
			awayMenuID = popup_m->insertItem(SmallIcon("buddy_away"), "&Away", awayMenu);

			// Disable the signon/signoff popup for some time, since we just got
			// online, and we don't want the popup to appear for all the
			// already-online buddies!
			delaySignonPopup = FALSE;
			QTimer::singleShot( POPUP_ENABLE_LOGIN_TIME * 1000, this,
						SLOT(signonPopupDelayedEnable()));
			break;
		case TAIM_AWAY:
			if(awayMenuID != -1)
				popup_m->removeItem(awayMenuID);
			awayMenuID = popup_m->insertItem(SmallIcon("buddy_away"), "&Back", this, SIGNAL(backClicked()));
			break;
	} //switch

	paintIcon();
}

/**
 * Toggle the visibility of the main window.
 */
void DockWidget::showKinkattaClicked(){
	if(kinkattaVisible)
		emit hideKinkatta();
	else
		emit showKinkatta();

	kinkattaVisible = !kinkattaVisible;

}

/**
 * Toggles visibility of all windows
 */
void DockWidget::showAllClicked(){
	if(allVisible)
		emit hideAll();
	else
		emit showAll();

	allVisible = !allVisible;
}

// kinkattadock.cpp

