/***************************************************************************
                             chatroominviteimp.h
                             -------------------
    begin                : Saturday March 24 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : ben-dev@meyerhome.net
 ***************************************************************************/

#ifndef CHATROOMINVITEIMP_H
#define CHATROOMINVITEIMP_H

#include <chatroominvite.h>

/**
 * Basic invite widget.  Has a list of buddies that people
 * can select from.  Emits inviteBuddy signal if ok is pressed.
 * @author Benjamin Meyer
 */

class ChatRoomInviteImp : public ChatRoomInvite {

Q_OBJECT
	
signals:
  /// Invite 'buddies' to this 'room' with the message 'message'
  void inviteBuddy(int room, QString message, QString listOfBuddys );

public:
  /// Constructor
  ChatRoomInviteImp(QWidget *parent=0, const char *name=0);
  
  /// Sets the room number to invite too.
  void setRoomNumber( int newRoomNumber = 0 );

private slots:
  /// Add the buddy name in the textbox to the list of buddies to invite
  void inviteBuddyButton();

  /// Add buddy from list to the list of buddies to invite
  void addBuddyButton();

  /// Add buddy from list to the list of buddies to invite
  void doubleClicked(QListBoxItem *);

private:
  /// The room that we should invite people too.
  int room;

};

#endif

// chatroominviteimp.h

