/***************************************************************************
                               application.h
                             -------------------
    begin                : Mon Jan 28 2002
    copyright            : (C) 2002 by Benjamin Meyer
    email                : ben-dev@meyerhome.net
 ***************************************************************************/

#ifndef KINKATTAAPPLICATION_H
#define KINKATTAAPPLICATION_H

#include <kapp.h> 

#define APP_NAME                    "Kinkatta"
#define APP_LOWERCASE_NAME          "kinkatta"
#define release_number "1.1-beta"
#define release_date "02/05/02"

class Login;

/**
 * KinkattaApplication provides kinkatta with global features.
 * Audio and web commands are sent and setup here and any part of the application
 * can access them.  application.h also stores global define's such as the current
 * version number.  The Main buddylist is main QApplication->mainWidget, but 
 * KinkattaApplication also stores a login window that can be shown when no online.
 * @author Benjamin Meyer
 */
class KinkattaApplication : public KApplication {
 
Q_OBJECT

public:
  /// Constructor.
  KinkattaApplication( int, char ** );

  /// Deconstructor.
  ~KinkattaApplication();

  /// Sets the sound command used to open a sound file.
  static void setSoundCommand( const QString &command = "artsplay" );

  /// Turn sound on and off.
  static void muteSound( bool=false );

  /// Display the login window
  static void showLoginWindow();

  /// The Kinkatta aim Login window
  static Login *loginWindow;

public slots:
  void playFile( const QString &file );
  void beep();

private:
  /// Command used when playFile is called
  static QString soundCommand;
  /// Boolian determinate if any audio should be outputed.
  static bool muteAudio;

};

inline void setSoundCommand( const QString &command ){
  KinkattaApplication::setSoundCommand(command);
}

inline void muteSound( bool muteChoice ){
  KinkattaApplication::muteSound(muteChoice);
}

#define kApp ((KinkattaApplication*)(KApplication::kApplication()))

#endif

// application.h

