/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
 *
 * Author: Gregory P. Myrdal <Myrdal@MissionCriticalLinux.Com>
 *
 * invalidatebuffers.c
 *
 *
 */

/*
 * Version string that is filled in by CVS
 */
static const char *version __attribute__ ((unused)) = "$Revision: 1.3 $";

/*
 * System includes
 */
#include <unistd.h>
#include <stdio.h>
#include <syslog.h>
#include <string.h>
#include <linux/fs.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdlib.h>
/*
 * Cluster includes
 */
#include <logger.h>

/*
 * External declarations
 */
extern int errno;

/***************************************************************************
 *
 * Functions
 *
 ***************************************************************************/

/*
 * printUsage
 *
 * Print out usage string to stdout.
 */
static void
printUsage(char *progName)
{
	clulog_and_print(LOG_ERR, "Usage: %s [-h] [-f device]\n", progName);
}

/***************************************************************************
 *
 * Main
 *
 ***************************************************************************/
int
main(int argc, char **argv)
{
	char opt;
	uid_t uid;
	char *devicename = (char *)NULL;
	int fd;

	uid=getuid();
	if (uid)
	  {
	    clulog_and_print(LOG_ERR, "%s should only be run as user root\n",
	            argv[0]);
	    exit(1);
	  }

	while ((opt = getopt(argc, argv, "f:h")) != -1)
	  {
	    switch (opt)
	      {
              case 'f':			// stop services
	        devicename = strdup(optarg);
	        break;

              case 'h':			// command line help
                printUsage(argv[0]);
	        exit(0);

              default:			// unknown option
                printUsage(argv[0]);     
	        exit(0);
	      }
	  }

	if (devicename == (char *)NULL)
	  {
	    printUsage(argv[0]);
	    exit(1);
	  }

	fd = open(devicename, O_RDONLY, 0);

	if (fd < 0)
	  {
	    clulog_and_print(LOG_ERR, "Cannot open %s for flushing: %s\n",
	            devicename, strerror(errno));
	    exit(1);
	  }

	if (ioctl(fd, BLKFLSBUF, 0) < 0)
	  {
	    clulog_and_print(LOG_ERR, "Cannot flush %s: %s\n",
	            devicename, strerror(errno));
	    exit(1);
	  }
	free(devicename);
	close(fd);           

	exit(0);
}
