/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
#ifndef DATABASE_H
#define DATABASE_H
/* database.h
   Author: Ron Lawrence <lawrence@missioncriticallinux.com> 
   Version: $Revision: 1.5 $ 
*/
#ifdef __cplusplus
extern "C" {
#endif

#ifndef	_SYS_TYPES_H
#include <sys/types.h>
#endif

  ssize_t getDatabaseLength(void); 
  ulong getDatabaseChecksum(void);
  ssize_t writeDatabase(char *data, ssize_t length); 
  ssize_t readDatabase(char *data, ssize_t max_length);
  int readScanWholeDatabase(void);
  int initializeConfigDatabase(void);
  int getDatabaseFromPartition(char* partitionName, char* buffer, ssize_t length);

#ifdef __cplusplus
}
#endif

#endif

