/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
#ifndef ALLOCATE_H
#define ALLOCATE_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>

/* allocate.h

   Author: Ron Lawrence <lawrence@missioncriticallinux.com>
   Version: $Revision: 1.3 $
*/

/*#define NDEBUG*/

/* An Attempt to allocate an item larger than this may fail. */

#define MEM_BLOCK_SIZE 0x10000

/* Globa pool interfaces */

/* Allocate a character array of n bytes in a hidden pool of
   memory. 

   Returns: 
   a pointer to the allocated storage.
   NULL if storage cannot be allocated.
*/

char* MEM_allocate_string(size_t n);

/* Release a previously allocated region of storage. 

   Returns:
   NULL on error.  Non-NULL otherwise.
*/

char* MEM_release_string(char* str);

/* Discards all of the memory associated with the internal pool.  All
   previously allocated strings are immediately de-allocated.  Woe
   betide those who attempt to de-reference pointers that were valid
   before the call.  You have been warned.  After all of the storage
   is released, the pool is re-initialized. */

void MEM_release_all(void);

/* Memory pool interfaces */

/* A handle on a memory pool */

struct MEM_pool;

/* Create a new memory allocation pool. */

struct MEM_pool* MEM_create_pool(size_t allot_increment);

/* Destroy a previously created pool. */

void MEM_destroy_pool(struct MEM_pool*);

/* Allocate a region of storage n bytes long in the given pool */

char* MEM_pool_allocate_string(struct MEM_pool* pool, size_t n);

/* Release storage associated with str from pool where it was
   previously allocated. */

char* MEM_pool_release_string(struct MEM_pool* pool, char* str);


#ifndef NDEBUG

/* Dump some strings to stdout that depict the current status of the
   pool. */

void MEM_dump(void);
void MEM_pool_dump(struct MEM_pool* pool);
#else

/* Normally defined to do nothing. */
#define MEM_pool_dump(anything) do {} while(0)
#define MEM_dump() do {} while(0)
#endif

#ifdef __cplusplus
}
#endif

#endif

