# kid distutils setup
import kid as _kid

name = "kid"
description = "Kid - A simple and pythonic XML template language"
long_description = "\n".join(_kid.__doc__.split('\n')[2:])
license = "MIT"
version = _kid.__version__
maintainer = author = 'Ryan Tomayko'
maintainer_email = author_email = 'rtomayko@gmail.com'

url = 'http://lesscode.org/projects/kid/'
download_url = 'http://lesscode.org/dist/kid/kid-' + version + '.tar.gz'
platforms = ["any"]

packages = ['kid', 'kid.test']
package_dir = {'kid':'kid', 'kid.test' : 'kid/test'}
scripts = ['bin/kidc', 'bin/kid']
options = { 'clean' : { 'all' : 1 } }
classifiers = [
        'Development Status :: 3 - Alpha',
        'Environment :: Console',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Text Processing :: Markup :: XML'
      ]

# load up distutils
if __name__ == '__main__':
  config = globals().copy()
  keys = config.keys()
  for k in keys:
    if k.startswith('_'):
      del config[k]
  from distutils.core import setup
  setup(**config)
