/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kiaxcallregister.h"

int KiaxCallRegister::createNewRecord()
{
    KiaxCallRecord * c = new KiaxCallRecord();
    return addRecord(c);
}


int KiaxCallRegister::addRecord(KiaxCallRecord * record)
{
    inSort(record);
    return find(record);
}

void KiaxCallRegister::removeAll() {
    int countRecords = count();
    for (int i=0; i<countRecords; i++) removeRecord(0);
}

void KiaxCallRegister::removeRecord(int recordNumber) {
  KiaxCallRecord* c = at(recordNumber);
  c->remove();
  remove(recordNumber);
}

void KiaxCallRegister::load() {
  
  QSettings * settings = getSettings();
  QStringList recordsList = settings->subkeyList("/kiaxcallregister/calls");
  delete settings;
    
  setAutoDelete(true); // this will dispose all 
  clear();
  
  recordsList.sort();
  
  for (QStringList::Iterator it = recordsList.begin();it!=recordsList.end(); ++it) {
     KiaxCallRecord * c = new KiaxCallRecord();
     c->load(*it);
     addRecord(c);
  }
  
}

void KiaxCallRegister::save() {
   for (uint i=0;i<count();i++) {
      KiaxCallRecord * c = at(i);
      c->save();
   }
}

QSettings * KiaxCallRegister::getSettings()
{
  QSettings * settings = new QSettings();
  settings->setPath("kiax.org","kiaxcallregister", QSettings::User);// userspace
  return settings;
}

KiaxCallRecord* KiaxCallRegister::getRecord(int i)
{
    return at(i);
}

int KiaxCallRegister::compareItems ( void* item1, void* item2 ) {
  KiaxCallRecord* i1 = (KiaxCallRecord*)item1;
  KiaxCallRecord* i2 = (KiaxCallRecord*)item2;
  if (i1->getCallStartTime()>i2->getCallStartTime()) return -1;
  else if (i1->getCallStartTime()<i2->getCallStartTime()) return 1;
    else return 0;
}
