#!/usr/bin/perl -w
# repath.pl is part of building scripts of the Kiax project
# used for replacing path strings in src/src.pro file.
#
# usage: repath.pl --prefix=<path>|--targetos=<os> --listos=1
# Author: Borislav Mitev <morbid_viper@tkzs.org>, 2005

use strict;
my $fnSrcpro = "src/src.pro";
my $fnMakefile = "bin/Makefile";
my %OSpaths = (
	suse => {
		icons => "/opt/kde3",
		translations => "/opt/kde3",
		binary => "/opt/kde3",
		ICONS_PATH => "/opt/kde3",
		I18N_DIRECTORY => "/opt/kde3",
		DEST_PATH => "/opt/kde3"
		},
	redhat => {
		icons => "/usr",
		translations => "/usr",
		binary => "/usr",
		ICONS_PATH => "/usr",
		I18N_DIRECTORY => "/usr",
		DEST_PATH => "/usr"
	},
	debian => {
		icons => "/usr/local",
		translations => "/usr/local",
		binary => "/usr/local",
		ICONS_PATH => "/usr/local",
		I18N_DIRECTORY => "/usr/local",
		DEST_PATH => "/usr/local"
	},
	slackware => {
		icons => "/usr/local",
		translations => "/usr/local",
		binary => "/usr/local",
		ICONS_PATH => "/usr/local",
		I18N_DIRECTORY => "/usr/local",
		DEST_PATH => "/usr/local"
	},
	mandrake => {
		icons => "/usr",
		translations => "/usr",
		binary => "/usr",
		ICONS_PATH => "/usr",
		I18N_DIRECTORY => "/usr",
		DEST_PATH => "/usr"
	},
	home => {
		icons => "$ENV{HOME}/kiax/icons",
		translations => "$ENV{HOME}/kiax/i18n",
		binary => "$ENV{HOME}/kiax",
		ICONS_PATH => "$ENV{HOME}/kiax/icons",
		I18N_DIRECTORY => "$ENV{HOME}/kiax/i18n",
		DEST_PATH => "$ENV{HOME}/kiax"
	}
);
my ($i, %params);

print "No prefix or targetos is given.\nLeaving src/src.pro untouched.\n" and exit(0) unless (@ARGV);

for($i = 0; $i < @ARGV; $i++){
	$ARGV[$i] =~ m/^--(.+?)=(.*)/;
	$params{$1} = $2;
}

open FH, $fnSrcpro or die "Can't open file $fnSrcpro: $!\n";
undef $/;
my $proFile = <FH>;
$/ = "\n";
close FH;

if($params{'listos'}){
	$, = ", ";
	print "Supported OS: ";
	print keys(%OSpaths);
	print "\n";
}elsif($params{'targetos'}){
	$proFile =~ s|icons\.path = .*?\n|icons.path = $OSpaths{$params{'targetos'}}{'icons'}/share/kiax/icons/\n|;
	$proFile =~ s|translations\.path = .*?\n|translations.path = $OSpaths{$params{'targetos'}}{'translations'}/share/kiax/i18n/\n|;
	$proFile =~ s|binary\.path = .*?\n|binary.path = $OSpaths{$params{'targetos'}}{'binary'}/bin/\n|;
	$proFile =~ s|ICONS_PATH=\\"./icons/\\"|ICONS_PATH=\\"$OSpaths{$params{'targetos'}}{'ICONS_PATH'}/share/kiax/icons/\\"|;
	$proFile =~ s|I18N_DIRECTORY=\\"./i18n/\\"|I18N_DIRECTORY=\\"$OSpaths{$params{'targetos'}}{'I18N_DIRECTORY'}/share/kiax/i18n/\\"|;
}elsif($params{'prefix'}){
	$proFile =~ s|icons\.path = .*?\n|icons.path = $params{'prefix'}/share/kiax/icons/\n|;
	$proFile =~ s|translations\.path = .*?\n|translations.path = $params{'prefix'}/share/kiax/i18n/\n|;
	$proFile =~ s|binary\.path = .*?\n|binary.path = $params{'prefix'}/bin/\n|;
	$proFile =~ s|ICONS_PATH=\\"./icons/\\"|ICONS_PATH=\\"$params{'prefix'}/share/kiax/icons/\\"|;
	$proFile =~ s|I18N_DIRECTORY=\\"./i18n/\\"|I18N_DIRECTORY=\\"$params{'prefix'}/share/kiax/i18n/\\"|;
}

open FH, ">$fnSrcpro" or die "Can't open file $fnSrcpro: $!\n";
print FH $proFile;
close FH;

open FH, $fnMakefile or die "Can't open file $fnMakefile: $!\n";
undef $/;
my $proFiles = <FH>;
$/ = "\n";
close FH;

if($params{'listos'}){
	$, = ", ";
	print "Supported OS: ";
	print keys(%OSpaths);
	print "\n";
}elsif($params{'targetos'}){
	$proFiles =~ s|DEST_PATH=.*?\n|DEST_PATH=$OSpaths{$params{'targetos'}}{'binary'}/bin/\n|;
}elsif($params{'prefix'}){
	$proFiles =~ s|DEST_PATH=.*?\n|DEST_PATH=$params{'prefix'}/bin/\n|;
}

open FH, ">$fnMakefile" or die "Can't open file $fnSrcpro: $!\n";
print FH $proFiles;
close FH;
