/***************************************************************************
                          colorlabel.cpp  -  description
                             -------------------
    begin                : Tue Sep 25 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "colorlabel.h"
#include "qcolordialog.h"

ColorLabel::ColorLabel( QColor foregroundColor, QColor backgroundColor, QWidget *parent, const char *name ) : QWidget( parent, name )
{
	foreground = QRect( 2, 2, 13, 10 );
	background = QRect( 10, 6, 13, 10 );

	drawColor	= foregroundColor;
	this->backgroundColor = backgroundColor;
}

ColorLabel::~ColorLabel()
{
}

void ColorLabel::paintEvent( QPaintEvent * )
{
  QPainter p( this );
	p.setPen( NoPen );
//	p.setBrush( white );
//	p.drawRect( 0, 0, width(), height() );
	p.setPen( QPen( Qt::darkGray, 1, Qt::SolidLine ) );
	p.setBrush( backgroundColor );
	p.drawRect( background );
	p.setBrush( drawColor );
	p.drawRect( foreground );

	p.flush();
}

void ColorLabel::mouseDoubleClickEvent( QMouseEvent * ev )
{
	QColor myColor;
	
	//	Check whether to change draw or background color
	if ( foreground.contains( ev->pos() ) )
	{
	  myColor = QColorDialog::getColor( drawColor );
	 	if ( myColor.isValid() )
		{
			drawColor = myColor;
			repaint();		
			emit drawColorChanged( drawColor );
		}
	}
	else
	{
  	if ( background.contains( ev->pos() ) )
  	{
		  myColor = QColorDialog::getColor( backgroundColor );
		 	if ( myColor.isValid() )
			{
				backgroundColor = myColor;
				repaint();		
				emit backgroundColorChanged( backgroundColor );
			}
		}
	}
}
