/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2005 by the KFTPGrabber developers
 * Copyright (C) 2003-2005 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
#ifndef KFTPTRAFFICGRAPH_H
#define KFTPTRAFFICGRAPH_H

#include <qpoint.h>
#include <qdialog.h>
#include <qptrlist.h>
#include <qstring.h>
#include <qvaluelist.h>

#define GRAPH_POLYGON     0
#define GRAPH_ORIGINAL    1

class QColor;

namespace KFTPWidgets {

/**
@author Jernej Kos
*/
class TrafficGraph : public QWidget
{
Q_OBJECT
public:
    TrafficGraph(QWidget *parent = 0, const char *name = 0);
    ~TrafficGraph();
    
    bool addBeam(const QColor &color);
    void addSample(const QValueList<double> &samples);

    void removeBeam(uint pos);

    void changeRange(int beam, double min, double max);

    QValueList<QColor> &beamColors();

    void setUseAutoRange(bool value);
    bool useAutoRange() const;

    void setMinValue(double min);
    double minValue() const;

    void setMaxValue(double max);
    double maxValue() const;

    void setGraphStyle(uint style);
    uint graphStyle() const;

    void setHorizontalScale(uint scale);
    uint horizontalScale() const;

    void setShowVerticalLines(bool value);
    bool showVerticalLines() const;

    void setVerticalLinesColor(const QColor &color);
    QColor verticalLinesColor() const;

    void setVerticalLinesDistance(int distance);
    int verticalLinesDistance() const;

    void setVerticalLinesScroll(bool value);
    bool verticalLinesScroll() const;

    void setShowHorizontalLines(bool value);
    bool showHorizontalLines() const;

    void setHorizontalLinesColor(const QColor &color);
    QColor horizontalLinesColor() const;

    void setHorizontalLinesCount(int count);
    int horizontalLinesCount() const;

    void setShowLabels(bool value);
    bool showLabels() const;

    void setShowTopBar(bool value);
    bool showTopBar() const;

    void setFontSize(int size);
    int fontSize() const;

    void setBackgroundColor(const QColor &color);
    QColor backgroundColor() const;
protected:
    void updateDataBuffers();

    virtual void resizeEvent(QResizeEvent*);
    virtual void paintEvent(QPaintEvent*);
private:
    double m_minValue;
    double m_maxValue;
    bool m_useAutoRange;

    uint m_graphStyle;

    bool m_showVerticalLines;
    QColor m_verticalLinesColor;
    uint m_verticalLinesDistance;
    bool m_verticalLinesScroll;
    uint m_verticalLinesOffset;
    uint m_horizontalScale;

    bool m_showHorizontalLines;
    QColor m_horizontalLinesColor;
    uint m_horizontalLinesCount;

    bool m_showLabels;
    bool m_showTopBar;
    uint m_fontSize;

    QColor m_backgroundColor;

    QPtrList<double> m_beamData;
    QValueList<QColor> m_beamColor;

    int m_samples;
};

}

#endif
