/******************************************************************************
 *
 * Module Name: dttemplate.h - ACPI table template definitions
 *
 *****************************************************************************/

/*
 * Copyright (C) 2000 - 2013, Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 */

#ifndef __DTTEMPLATE_H
#define __DTTEMPLATE_H


/* Special templates for DSDT and SSDT (AML byte-code tables) */

const char TemplateDsdt[] =
    "DefinitionBlock (\"dsdt.aml\", \"DSDT\", 2, \"Intel\", \"Template\", 0x00000001)\n"
    "{\n"
    "    Method (MAIN, 0, NotSerialized)\n"
    "    {\n"
    "        Return (Zero)\n"
    "    }\n"
    "}\n\n";

const char TemplateSsdt[] =
    "DefinitionBlock (\"ssdt.aml\", \"SSDT\", 2, \"Intel\", \"Template\", 0x00000001)\n"
    "{\n"
    "    Method (MAIN, 0, NotSerialized)\n"
    "    {\n"
    "        Return (Zero)\n"
    "    }\n"
    "}\n\n";


/* Templates for ACPI data tables */

const unsigned char TemplateAsf[] =
{
    0x41,0x53,0x46,0x21,0x72,0x00,0x00,0x00,  /* 00000000    "ASF!r..." */
    0x10,0x0B,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x10,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x14,0x00,  /* 00000030    "........" */
    0x00,0x00,0x01,0x0C,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x02,0x00,0x0C,0x00,0x01,0x04,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x03,0x00,0x17,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x84,0x00,0x07,0x00,0x00,  /* 00000068    "........" */
    0x01,0x00                                 /* 00000070    ".."       */
};

const unsigned char TemplateBgrt[] =
{
    0x42,0x47,0x52,0x54,0x38,0x00,0x00,0x00,  /* 00000000    "BGRT8..." */
    0x01,0x0D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x23,0x06,0x11,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "#.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000030    "........" */
};

const unsigned char TemplateBert[] =
{
    0x42,0x45,0x52,0x54,0x30,0x00,0x00,0x00,  /* 00000000    "BERT0..." */
    0x01,0x15,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000028    "........" */
};

const unsigned char TemplateBoot[] =
{
    0x42,0x4F,0x4F,0x54,0x28,0x00,0x00,0x00,  /* 00000000    "BOOT(..." */
    0x01,0x0D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x04,0x06,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00   /* 00000020    "(.. ...." */
};

const unsigned char TemplateCpep[] =
{
    0x43,0x50,0x45,0x50,0x34,0x00,0x00,0x00,  /* 00000000    "CPEP4..." */
    0x01,0x0F,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplateCsrt[] =
{
    0x43,0x53,0x52,0x54,0x4C,0x01,0x00,0x00,  /* 00000000    "CSRTL..." */
    0x01,0x0D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x14,0x11,0x12,0x20,0x88,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x49,0x4E,0x54,0x4C,0x00,0x00,0x00,0x00,  /* 00000028    "INTL...." */
    0x60,0x9C,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000030    "`......." */
    0x1C,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0xA0,0xB3,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x2A,0x00,0x00,0x00,0x02,0x00,0x06,0x20,  /* 00000048    "*...... " */
    0x00,0x00,0x10,0x00,0xFF,0x0F,0x00,0x00,  /* 00000050    "........" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x01,0x00,  /* 00000058    "........" */
    0x53,0x50,0x49,0x20,0x0C,0x00,0x00,0x00,  /* 00000060    "SPI ...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x30,  /* 00000068    "....CHA0" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000070    "........" */
    0x43,0x48,0x41,0x31,0x0C,0x00,0x00,0x00,  /* 00000078    "CHA1...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x32,  /* 00000080    "....CHA2" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000088    "........" */
    0x43,0x48,0x41,0x33,0x0C,0x00,0x00,0x00,  /* 00000090    "CHA3...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x34,  /* 00000098    "....CHA4" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x43,0x48,0x41,0x35,0xA0,0x00,0x00,0x00,  /* 000000A8    "CHA5...." */
    0x49,0x4E,0x54,0x4C,0x00,0x00,0x00,0x00,  /* 000000B0    "INTL...." */
    0x60,0x9C,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000B8    "`......." */
    0x1C,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x2B,0x00,0x00,0x00,0x02,0x00,0x08,0x20,  /* 000000D0    "+...... " */
    0x10,0x00,0x10,0x00,0xFF,0x0F,0x00,0x00,  /* 000000D8    "........" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x01,0x00,  /* 000000E0    "........" */
    0x49,0x32,0x43,0x20,0x0C,0x00,0x00,0x00,  /* 000000E8    "I2C ...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x30,  /* 000000F0    "....CHA0" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x43,0x48,0x41,0x31,0x0C,0x00,0x00,0x00,  /* 00000100    "CHA1...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x32,  /* 00000108    "....CHA2" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000110    "........" */
    0x43,0x48,0x41,0x33,0x0C,0x00,0x00,0x00,  /* 00000118    "CHA3...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x34,  /* 00000120    "....CHA4" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000128    "........" */
    0x43,0x48,0x41,0x35,0x0C,0x00,0x00,0x00,  /* 00000130    "CHA5...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x36,  /* 00000138    "....CHA6" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000140    "........" */
    0x43,0x48,0x41,0x37                       /* 00000148    "CHA7"     */
};

const unsigned char TemplateDbgp[] =
{
    0x44,0x42,0x47,0x50,0x34,0x00,0x00,0x00,  /* 00000000    "DBGP4..." */
    0x01,0x1A,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplateDmar[] =
{
    0x44,0x4D,0x41,0x52,0x8C,0x00,0x00,0x00,  /* 00000000    "DMAR...." */
    0x01,0x03,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x17,0x05,0x13,0x20,0x2F,0x01,0x00,0x00,  /* 00000020    "... /..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x18,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x03,0x08,0x00,0x00,0x08,0x00,0x00,0x01,  /* 00000040    "........" */
    0x01,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 00000048    ".. ....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x01,0x08,0x00,0x00,0x00,0x00,0x00,0x02,  /* 00000060    "........" */
    0x02,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x02,0x08,0x00,0x00,0x00,0x00,0x00,0x03,  /* 00000070    "........" */
    0x03,0x00,0x14,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00                       /* 00000088    "...."     */
};

const unsigned char TemplateEcdt[] =
{
    0x45,0x43,0x44,0x54,0x42,0x00,0x00,0x00,  /* 00000000    "ECDTB..." */
    0x01,0x2D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".-INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x01,0x08,0x00,0x00,  /* 00000020    "(.. ...." */
    0x66,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "f......." */
    0x01,0x08,0x00,0x00,0x62,0x00,0x00,0x00,  /* 00000030    "....b..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x09,0x00                                 /* 00000040    ".."       */
};

const unsigned char TemplateEinj[] =
{
    0x45,0x49,0x4E,0x4A,0x30,0x01,0x00,0x00,  /* 00000000    "EINJ0..." */
    0x01,0x09,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x30,0x00,0x00,0x00,  /* 00000020    "(.. 0..." */
    0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000030    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000048    "........" */
    0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000050    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000068    "........" */
    0x02,0x02,0x01,0x00,0x00,0x40,0x00,0x04,  /* 00000070    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000088    "........" */
    0x03,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000090    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000A8    "........" */
    0x04,0x03,0x01,0x00,0x00,0x40,0x00,0x04,  /* 000000B0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000C8    "........" */
    0x05,0x03,0x01,0x00,0x01,0x10,0x00,0x02,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000E8    "........" */
    0x06,0x01,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000000F0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000108    "........" */
    0x07,0x00,0x01,0x00,0x00,0x40,0x00,0x04,  /* 00000110    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF   /* 00000128    "........" */
};

const unsigned char TemplateErst[] =
{
    0x45,0x52,0x53,0x54,0x30,0x02,0x00,0x00,  /* 00000000    "ERST0..." */
    0x01,0xAB,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x30,0x00,0x00,0x00,  /* 00000020    "(.. 0..." */
    0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000030    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000048    "........" */
    0x01,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000050    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000068    "........" */
    0x02,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000070    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000088    "........" */
    0x03,0x04,0x01,0x00,0x00,0x40,0x00,0x04,  /* 00000090    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000A8    "........" */
    0x04,0x02,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000000B0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000C8    "........" */
    0x05,0x03,0x00,0x00,0x01,0x08,0x00,0x01,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000E8    "........" */
    0x06,0x01,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000000F0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000108    "........" */
    0x07,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000110    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000128    "........" */
    0x08,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000130    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000148    "........" */
    0x09,0x02,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000150    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000168    "........" */
    0x0A,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000170    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000188    "........" */
    0x0B,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000190    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000198    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000001A8    "........" */
    0x0C,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000001B0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000001C8    "........" */
    0x0D,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000001D0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001E0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000001E8    "........" */
    0x0E,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000001F0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000200    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000208    "........" */
    0x0F,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000210    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000218    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000220    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF   /* 00000228    "........" */
};

const unsigned char TemplateFacs[] =
{
    0x46,0x41,0x43,0x53,0x40,0x00,0x00,0x00,  /* 00000000    "FACS@..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000008    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000010    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000018    "........" */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000020    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000038    "........" */
};

/* Version 5 FADT */

const unsigned char TemplateFadt[] =
{
    0x46,0x41,0x43,0x50,0x0C,0x01,0x00,0x00,  /* 00000000    "FACP...." */
    0x05,0x18,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x23,0x11,0x11,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "#.. ...." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000048    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x04,0x02,0x01,0x04,0x08,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x01,  /* 00000070    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x02,  /* 00000090    "..... .." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x01,0x10,0x00,0x02,  /* 000000A8    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x00,  /* 000000C0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x01,0x20,0x00,0x03,0x01,0x00,0x00,0x00,  /* 000000D0    ". ......" */
    0x00,0x00,0x00,0x00,0x01,0x80,0x00,0x01,  /* 000000D8    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x01,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x01,0x08,0x00,0x01,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x00,0x00,0x00                       /* 00000108    "...."     */
};

const unsigned char TemplateFpdt[] =
{
    0x46,0x50,0x44,0x54,0x64,0x00,0x00,0x00,  /* 00000000    "FPDTd..." */
    0x01,0xBD,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x04,0x08,0x11,0x20,0x00,0x00,0x30,0x01,  /* 00000020    "... ..0." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x10,0x01,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00                       /* 00000060    "...."     */
};

const unsigned char TemplateGtdt[] =
{
    0x47,0x54,0x44,0x54,0x50,0x00,0x00,0x00,  /* 00000000    "GTDTP..." */
    0x01,0xF1,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x23,0x06,0x11,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "#.. ...." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000048    "........" */
};

const unsigned char TemplateHest[] =
{
    0x48,0x45,0x53,0x54,0xD4,0x01,0x00,0x00,  /* 00000000    "HEST...." */
    0x01,0x20,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ". INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x04,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,  /* 00000028    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x01,  /* 00000088    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x01,  /* 000000F0    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,  /* 00000120    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000130    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x00,0x09,0x00,0x02,0x00,  /* 00000150    "........" */
    0xFF,0xFF,0x00,0x01,0x01,0x00,0x00,0x00,  /* 00000158    "........" */
    0x01,0x00,0x00,0x00,0x00,0x10,0x00,0x00,  /* 00000160    "........" */
    0x00,0x40,0x00,0x04,0x00,0x00,0x00,0x00,  /* 00000168    ".@......" */
    0x00,0x00,0x00,0x00,0x03,0x1C,0x00,0x00,  /* 00000170    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000188    "........" */
    0x00,0x10,0x00,0x00,0x09,0x00,0x03,0x00,  /* 00000190    "........" */
    0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,  /* 00000198    "........" */
    0x01,0x00,0x00,0x00,0x00,0x10,0x00,0x00,  /* 000001A0    "........" */
    0x00,0x40,0x00,0x04,0x00,0x00,0x00,0x00,  /* 000001A8    ".@......" */
    0x00,0x00,0x00,0x00,0x04,0x1C,0x00,0x00,  /* 000001B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C8    "........" */
    0x00,0x10,0x00,0x00                       /* 000001D0    "...."     */
};

const unsigned char TemplateHpet[] =
{
    0x48,0x50,0x45,0x54,0x38,0x00,0x00,0x00,  /* 00000000    "HPET8..." */
    0x01,0x09,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000030    "........" */
};

const unsigned char TemplateIvrs[] =
{
    0x49,0x56,0x52,0x53,0xBC,0x00,0x00,0x00,  /* 00000000    "IVRS...." */
    0x01,0x87,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x10,0x14,0x34,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "..4....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,  /* 00000048    "....@..." */
    0x00,0x00,0x00,0x00,0x42,0x00,0x00,0x00,  /* 00000050    "....B..." */
    0x00,0x00,0x00,0x00,0x48,0x00,0x00,0x00,  /* 00000058    "....H..." */
    0x00,0x00,0x00,0x00,0x20,0x08,0x20,0x00,  /* 00000060    ".... . ." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x21,0x04,0x20,0x00,  /* 00000080    "....!. ." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x10,0x14,0x18,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00                       /* 000000B8    "...."     */
};

/* MADT with ACPI 5.0 subtables */

const unsigned char TemplateMadt[] =
{
    0x41,0x50,0x49,0x43,0xF6,0x00,0x00,0x00,  /* 00000000    "APIC...." */
    0x01,0xB0,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x23,0x06,0x11,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "#.. ...." */
    0x01,0x00,0x00,0x00,0x00,0x08,0x00,0x00,  /* 00000028    "........" */
    0x01,0x00,0x00,0x00,0x01,0x0C,0x01,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x02,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x03,0x08,0x0D,0x00,0x01,0x00,  /* 00000048    "........" */
    0x00,0x00,0x04,0x06,0x00,0x05,0x00,0x01,  /* 00000050    "........" */
    0x05,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x06,0x10,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x07,0x16,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x5C,0x43,0x50,0x55,  /* 00000080    "....\CPU" */
    0x30,0x00,0x08,0x10,0x05,0x00,0x00,0x00,  /* 00000088    "0......." */
    0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,  /* 00000090    "........" */
    0x00,0x00,0x09,0x10,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x0A,0x0C,0x05,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x28,  /* 000000B0    ".......(" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x18,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00             /* 000000F0    "......"   */
};

const unsigned char TemplateMcfg[] =
{
    0x4D,0x43,0x46,0x47,0x3C,0x00,0x00,0x00,  /* 00000000    "MCFG<..." */
    0x01,0x19,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00                       /* 00000038    "...."     */
};

const unsigned char TemplateMchi[] =
{
    0x4D,0x43,0x48,0x49,0x45,0x00,0x00,0x00,  /* 00000000    "MCHIE..." */
    0x01,0xE4,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x15,0x07,0x00,0x02,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x02,0x08,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00                  /* 00000040    "....."    */
};

const unsigned char TemplateMpst[] =
{
    0x4D,0x50,0x53,0x54,0xB6,0x00,0x00,0x00,  /* 00000000    "MPST...." */
    0x01,0x77,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".wINTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x13,0x09,0x12,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000040    "........" */
    0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x01,0x00,0x02,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 00000068    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00             /* 000000B0    "......"   */
};

const unsigned char TemplateMsct[] =
{
    0x4D,0x53,0x43,0x54,0x90,0x00,0x00,0x00,  /* 00000000    "MSCT...." */
    0x01,0xB7,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x38,0x00,0x00,0x00,  /* 00000020    "(.. 8..." */
    0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0x0F,0x00,0x00,  /* 00000030    "........" */
    0x01,0x16,0x00,0x00,0x00,0x00,0x03,0x00,  /* 00000038    "........" */
    0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x40,0x00,0x00,0x00,0x01,0x16,  /* 00000048    "..@....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x01,0x16,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x01,0x16,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000088    "........" */
};

const unsigned char TemplateMtmr[] =
{
    0x4D,0x54,0x4D,0x52,0x4C,0x00,0x00,0x00,  /* 00000000    "MTMRL..." */
    0x01,0xB0,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x03,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x17,0x01,0x13,0x20,0x00,0x20,0x00,0x03,  /* 00000020    "... . .." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x20,0x00,0x03,0x00,0x00,0x00,0x00,  /* 00000038    ". ......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00                       /* 00000048    "...."     */
};

const unsigned char TemplatePmtt[] =
{
    0x50,0x4D,0x54,0x54,0xB4,0x00,0x00,0x00,  /* 00000000    "PMTT...." */
    0x01,0x3A,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".:INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x26,0x08,0x11,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "&.. ...." */
    0x00,0x00,0x80,0x00,0x01,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x54,0x00,  /* 00000030    "......T." */
    0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x02,0x00,0x14,0x00,0x02,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x02,0x00,0x14,0x00,  /* 00000070    "........" */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x01,0x00,0x20,0x00,0x01,0x00,0x00,0x00,  /* 00000088    ".. ....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x0C,0x00,0x01,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00                       /* 000000B0    "...."     */
};

const unsigned char TemplateRsdp[] =
{
    0x52,0x53,0x44,0x20,0x50,0x54,0x52,0x20,  /* 00000000    "RSD PTR " */
    0x43,0x49,0x4E,0x54,0x45,0x4C,0x20,0x02,  /* 00000008    "CINTEL ." */
    0x00,0x00,0x00,0x00,0x24,0x00,0x00,0x00,  /* 00000010    "....$..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000018    "........" */
    0xDC,0x00,0x00,0x00                       /* 00000020    "...."     */
};

const unsigned char TemplateRsdt[] =
{
    0x52,0x53,0x44,0x54,0x44,0x00,0x00,0x00,  /* 00000000    "RSDTD..." */
    0x01,0xB1,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x10,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x20,0x00,0x00,0x00,0x30,0x00,0x00,0x00,  /* 00000028    " ...0..." */
    0x40,0x00,0x00,0x00,0x50,0x00,0x00,0x00,  /* 00000030    "@...P..." */
    0x60,0x00,0x00,0x00,0x70,0x00,0x00,0x00,  /* 00000038    "`...p..." */
    0x80,0x00,0x00,0x00                       /* 00000040    "...."     */
};

const unsigned char TemplateS3pt[] =
{
    0x53,0x33,0x50,0x54,0x34,0x00,0x00,0x00,  /* 00000000    "S3PT4..." */
    0x00,0x00,0x18,0x01,0x00,0x00,0x00,0x00,  /* 00000008    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000010    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000018    "........" */
    0x01,0x00,0x14,0x01,0x00,0x00,0x00,0x00,  /* 00000020    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplateSbst[] =
{
    0x53,0x42,0x53,0x54,0x30,0x00,0x00,0x00,  /* 00000000    "SBST0..." */
    0x01,0x06,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000028    "........" */
};

const unsigned char TemplateSlic[] =
{
    0x53,0x4C,0x49,0x43,0x76,0x01,0x00,0x00,  /* 00000000    "SLICv..." */
    0x01,0x07,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x11,0x02,0x11,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x9C,0x00,0x00,0x00,0x06,0x02,0x00,0x00,  /* 00000028    "........" */
    0x00,0x24,0x00,0x00,0x52,0x53,0x41,0x31,  /* 00000030    ".$..RSA1" */
    0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x01,0x00,0x00,0x00,0xB6,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x02,0x00,0x49,0x4E,0x54,0x45,  /* 000000C8    "....INTE" */
    0x4C,0x20,0x54,0x45,0x4D,0x50,0x4C,0x41,  /* 000000D0    "L TEMPLA" */
    0x54,0x45,0x57,0x49,0x4E,0x44,0x4F,0x57,  /* 000000D8    "TEWINDOW" */
    0x53,0x20,0x01,0x00,0x02,0x00,0x00,0x00,  /* 000000E0    "S ......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000130    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000168    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00             /* 00000170    "......"   */
};

const unsigned char TemplateSlit[] =
{
    0x53,0x4C,0x49,0x54,0xBC,0x01,0x00,0x00,  /* 00000000    "SLIT...." */
    0x01,0x00,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x16,0x03,0x11,0x20,0x14,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x0A,0x10,0x16,0x17,  /* 00000028    "........" */
    0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,  /* 00000030    "........" */
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,  /* 00000038    " !"#$%&'" */
    0x10,0x0A,0x15,0x16,0x17,0x18,0x19,0x1A,  /* 00000040    "........" */
    0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,  /* 00000048    "..... !"" */
    0x23,0x24,0x25,0x26,0x16,0x15,0x0A,0x10,  /* 00000050    "#$%&...." */
    0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,  /* 00000058    "........" */
    0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,  /* 00000060    ".. !"#$%" */
    0x17,0x16,0x10,0x0A,0x15,0x16,0x17,0x18,  /* 00000068    "........" */
    0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,  /* 00000070    "....... " */
    0x21,0x22,0x23,0x24,0x18,0x17,0x16,0x15,  /* 00000078    "!"#$...." */
    0x0A,0x10,0x16,0x17,0x18,0x19,0x1A,0x1B,  /* 00000080    "........" */
    0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,  /* 00000088    ".... !"#" */
    0x19,0x18,0x17,0x16,0x10,0x0A,0x15,0x16,  /* 00000090    "........" */
    0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,  /* 00000098    "........" */
    0x1F,0x20,0x21,0x22,0x1A,0x19,0x18,0x17,  /* 000000A0    ". !"...." */
    0x16,0x15,0x0A,0x10,0x16,0x17,0x18,0x19,  /* 000000A8    "........" */
    0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,  /* 000000B0    "...... !" */
    0x1B,0x1A,0x19,0x18,0x17,0x16,0x10,0x0A,  /* 000000B8    "........" */
    0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,  /* 000000C0    "........" */
    0x1D,0x1E,0x1F,0x20,0x1C,0x1B,0x1A,0x19,  /* 000000C8    "... ...." */
    0x18,0x17,0x16,0x15,0x0A,0x10,0x16,0x17,  /* 000000D0    "........" */
    0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,  /* 000000D8    "........" */
    0x1D,0x1C,0x1B,0x1A,0x19,0x18,0x17,0x16,  /* 000000E0    "........" */
    0x10,0x0A,0x15,0x16,0x17,0x18,0x19,0x1A,  /* 000000E8    "........" */
    0x1B,0x1C,0x1D,0x1E,0x1E,0x1D,0x1C,0x1B,  /* 000000F0    "........" */
    0x1A,0x19,0x18,0x17,0x16,0x15,0x0A,0x10,  /* 000000F8    "........" */
    0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,  /* 00000100    "........" */
    0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,0x19,0x18,  /* 00000108    "........" */
    0x17,0x16,0x10,0x0A,0x15,0x16,0x17,0x18,  /* 00000110    "........" */
    0x19,0x1A,0x1B,0x1C,0x20,0x1F,0x1E,0x1D,  /* 00000118    ".... ..." */
    0x1C,0x1B,0x1A,0x19,0x18,0x17,0x16,0x15,  /* 00000120    "........" */
    0x0A,0x10,0x16,0x17,0x18,0x19,0x1A,0x1B,  /* 00000128    "........" */
    0x21,0x20,0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,  /* 00000130    "! ......" */
    0x19,0x18,0x17,0x16,0x10,0x0A,0x15,0x16,  /* 00000138    "........" */
    0x17,0x18,0x19,0x1A,0x22,0x21,0x20,0x1F,  /* 00000140    "...."! ." */
    0x1E,0x1D,0x1C,0x1B,0x1A,0x19,0x18,0x17,  /* 00000148    "........" */
    0x16,0x15,0x0A,0x10,0x16,0x17,0x18,0x19,  /* 00000150    "........" */
    0x23,0x22,0x21,0x20,0x1F,0x1E,0x1D,0x1C,  /* 00000158    "#"! ...." */
    0x1B,0x1A,0x19,0x18,0x17,0x16,0x10,0x0A,  /* 00000160    "........" */
    0x15,0x16,0x17,0x18,0x24,0x23,0x22,0x21,  /* 00000168    "....$#"!" */
    0x20,0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,0x19,  /* 00000170    " ......." */
    0x18,0x17,0x16,0x15,0x0A,0x10,0x16,0x17,  /* 00000178    "........" */
    0x25,0x24,0x23,0x22,0x21,0x20,0x1F,0x1E,  /* 00000180    "%$#"! .." */
    0x1D,0x1C,0x1B,0x1A,0x19,0x18,0x17,0x16,  /* 00000188    "........" */
    0x10,0x0A,0x15,0x16,0x26,0x25,0x24,0x23,  /* 00000190    "....&%$#" */
    0x22,0x21,0x20,0x1F,0x1E,0x1D,0x1C,0x1B,  /* 00000198    ""! ....." */
    0x1A,0x19,0x18,0x17,0x16,0x15,0x0A,0x10,  /* 000001A0    "........" */
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,  /* 000001A8    "'&%$#"! " */
    0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,0x19,0x18,  /* 000001B0    "........" */
    0x17,0x16,0x10,0x0A                       /* 000001B8    "...."     */
};

const unsigned char TemplateSpcr[] =
{
    0x53,0x50,0x43,0x52,0x50,0x00,0x00,0x00,  /* 00000000    "SPCRP..." */
    0x01,0xE3,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000048    "........" */
};

const unsigned char TemplateSpmi[] =
{
    0x53,0x50,0x4D,0x49,0x41,0x00,0x00,0x00,  /* 00000000    "SPMIA..." */
    0x04,0xED,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x08,0x00,0x01,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00                                      /* 00000040    "."        */
};

const unsigned char TemplateSrat[] =
{
    0x53,0x52,0x41,0x54,0x80,0x00,0x00,0x00,  /* 00000000    "SRAT...." */
    0x03,0x5A,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".ZINTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x10,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x01,0x28,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    ".(......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0xFC,0x09,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x02,0x18,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000078    "........" */
};

const unsigned char TemplateTcpa[] =
{
    0x54,0x43,0x50,0x41,0x32,0x00,0x00,0x00,  /* 00000000    "TCPA2..." */
    0x01,0x67,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".gINTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x80,0x31,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    ".1..INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00                                 /* 00000030    ".."       */
};

const unsigned char TemplateTpm2[] =
{
    0x54,0x50,0x4D,0x32,0x34,0x00,0x00,0x00,  /* 00000000    "TPM24..." */
    0x03,0x42,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".BINTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x14,0x11,0x12,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x77,0x66,0x55,0x44,0x33,0x22,0x11,0x00,  /* 00000028    "wfUD3".." */
    0x01,0x00,0x00,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplateUefi[] =
{
    0x55,0x45,0x46,0x49,0x36,0x00,0x00,0x00,  /* 00000000    "UEFI6..." */
    0x01,0x9B,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x01,0x02,0x03,  /* 00000020    "(.. ...." */
    0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,  /* 00000028    "........" */
    0x0C,0x0D,0x0E,0x0F,0x00,0x00             /* 00000030    "......"   */
};

const unsigned char TemplateVrtc[] =
{
    0x56,0x52,0x54,0x43,0x44,0x00,0x00,0x00,  /* 00000000    "VRTCD..." */
    0x01,0xEF,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x03,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x17,0x01,0x13,0x20,0x00,0x08,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00                       /* 00000040    "...."     */
};

const unsigned char TemplateWaet[] =
{
    0x57,0x41,0x45,0x54,0x28,0x00,0x00,0x00,  /* 00000000    "WAET(..." */
    0x01,0x19,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00   /* 00000020    "(.. ...." */
};

const unsigned char TemplateWdat[] =
{
    0x57,0x44,0x41,0x54,0x5C,0x00,0x00,0x00,  /* 00000000    "WDAT\..." */
    0x01,0xE3,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x20,0x00,0x00,0x00,  /* 00000020    "(..  ..." */
    0xFF,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,  /* 00000028    "........" */
    0x58,0x02,0x00,0x00,0xFF,0x03,0x00,0x00,  /* 00000030    "X......." */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x0E,0x00,0x00,0x00,0x01,0x02,0x00,0x00,  /* 00000040    "........" */
    0x01,0x10,0x00,0x02,0x60,0x04,0x00,0x00,  /* 00000048    "....`..." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000050    "........" */
    0x01,0x00,0x00,0x00                       /* 00000058    "...."     */
};

const unsigned char TemplateWddt[] =
{
    0x57,0x44,0x44,0x54,0x40,0x00,0x00,0x00,  /* 00000000    "WDDT@..." */
    0x01,0x00,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x01,0xFF,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000038    "........" */
};

const unsigned char TemplateWdrt[] =
{
    0x57,0x44,0x52,0x54,0x47,0x00,0x00,0x00,  /* 00000000    "WDRTG..." */
    0x01,0xB0,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x20,0x00,0x00,  /* 00000020    "(.. . .." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    ". ......" */
    0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0xFF,0xFF,0x00        /* 00000040    "......."  */
};

const unsigned char TemplateXsdt[] =
{
    0x58,0x53,0x44,0x54,0x64,0x00,0x00,0x00,  /* 00000000    "XSDTd..." */
    0x01,0x8B,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x10,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,  /* 00000028    ".... ..." */
    0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,  /* 00000030    "....0..." */
    0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,  /* 00000038    "....@..." */
    0x00,0x00,0x00,0x00,0x50,0x00,0x00,0x00,  /* 00000040    "....P..." */
    0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,  /* 00000048    "....`..." */
    0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,  /* 00000050    "....p..." */
    0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00                       /* 00000060    "...."     */
};

#endif
